% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixed-methods.R
\name{augment.beezdemand_nlme}
\alias{augment.beezdemand_nlme}
\title{Augment a beezdemand_nlme Model with Fitted Values and Residuals}
\usage{
\method{augment}{beezdemand_nlme}(x, newdata = NULL, ...)
}
\arguments{
\item{x}{An object of class \code{beezdemand_nlme}.}

\item{newdata}{Optional data frame of new data for prediction. If NULL,
uses the original data from the model.}

\item{...}{Additional arguments (currently unused).}
}
\value{
A tibble containing the original data plus:
\describe{
\item{.fitted}{Fitted values on the model scale (may be transformed, e.g., LL4)}
\item{.resid}{Residuals on the model scale}
\item{.fixed}{Fitted values from fixed effects only (population-level)}
}
}
\description{
Returns the original data with fitted values and residuals from a nonlinear
mixed-effects demand model. This enables easy model diagnostics and
visualization with the tidyverse.
}
\details{
The fitted values and residuals are on the same scale as the response variable
used in the model. For \code{equation_form = "zben"}, this is the LL4-transformed
scale. For \code{equation_form = "simplified"} or \code{"exponentiated"}, this is the natural
consumption scale.

To back-transform predictions to the natural scale for "zben" models, use:
\code{ll4_inv(augmented$.fitted)}
}
\examples{
\donttest{
data(ko)
fit <- fit_demand_mixed(ko, y_var = "y_ll4", x_var = "x",
                        id_var = "monkey", factors = "dose", equation_form = "zben")
augmented <- augment(fit)

# Plot residuals
library(ggplot2)
ggplot(augmented, aes(x = .fitted, y = .resid)) +
  geom_point(alpha = 0.5) +
  geom_hline(yintercept = 0, linetype = "dashed")
}

}
