% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hurdle-methods.R
\name{augment.beezdemand_hurdle}
\alias{augment.beezdemand_hurdle}
\title{Augment a beezdemand_hurdle Model with Fitted Values and Residuals}
\usage{
\method{augment}{beezdemand_hurdle}(x, newdata = NULL, ...)
}
\arguments{
\item{x}{An object of class \code{beezdemand_hurdle}.}

\item{newdata}{Optional data frame of new data for prediction. If NULL,
uses the original data from the model.}

\item{...}{Additional arguments (currently unused).}
}
\value{
A tibble containing the original data plus:
\describe{
\item{.fitted}{Fitted demand values (natural scale)}
\item{.fitted_link}{Fitted values on log scale (Part II mean)}
\item{.fitted_prob}{Predicted probability of consumption (1 - P(zero))}
\item{.resid}{Residuals on log scale for positive observations, NA for zeros}
\item{.resid_response}{Residuals on response scale (y - .fitted)}
}
}
\description{
Returns the original data with fitted values, residuals, and predictions
from a hurdle demand model. This enables easy model diagnostics and
visualization with the tidyverse.
}
\details{
For two-part hurdle models:
\itemize{
\item \code{.fitted} gives predicted demand on the natural consumption scale
\item \code{.fitted_prob} gives the predicted probability of positive consumption
\item \code{.resid} is defined only for positive observations as log(y) - .fitted_link
\item Observations with zero consumption have \code{.resid = NA} since they are
explained by Part I (the zero-probability component), not Part II
}
}
\examples{
\donttest{
data(apt)
fit <- fit_demand_hurdle(apt, y_var = "y", x_var = "x", id_var = "id")
augmented <- augment(fit)

# Plot residuals
library(ggplot2)
ggplot(augmented, aes(x = .fitted, y = .resid)) +
  geom_point(alpha = 0.5) +
  geom_hline(yintercept = 0, linetype = "dashed")
}

}
