% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixed-methods.R
\name{augment.beezdemand_fixed}
\alias{augment.beezdemand_fixed}
\title{Augment a beezdemand_fixed Model with Fitted Values and Residuals}
\usage{
\method{augment}{beezdemand_fixed}(x, newdata = NULL, ...)
}
\arguments{
\item{x}{An object of class \code{beezdemand_fixed}.}

\item{newdata}{Optional data frame of new data for prediction. If NULL,
uses the original data from the model.}

\item{...}{Additional arguments (currently unused).}
}
\value{
A tibble containing the original data plus:
\describe{
\item{.fitted}{Fitted demand values on the response scale}
\item{.resid}{Residuals (observed - fitted)}
}
}
\description{
Returns the original data with fitted values and residuals from individual
demand curve fits. This enables easy model diagnostics and visualization
with the tidyverse.
}
\details{
For "hs" equation models where fitting is done on the log10 scale,
fitted values are back-transformed to the natural scale.
}
\examples{
\donttest{
data(apt)
fit <- fit_demand_fixed(apt, y_var = "y", x_var = "x", id_var = "id")
augmented <- augment(fit)

# Plot residuals by subject
library(ggplot2)
ggplot(augmented, aes(x = .fitted, y = .resid)) +
  geom_point(alpha = 0.5) +
  facet_wrap(~id) +
  geom_hline(yintercept = 0, linetype = "dashed")
}

}
