% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{apt_full}
\alias{apt_full}
\title{Full alcohol purchase task dataset}
\format{
A data frame with 18,700 rows and 8 columns:
\describe{
\item{id}{Unique participant identifier (1-1100)}
\item{gender}{Participant gender (Male/Female)}
\item{age}{Participant age in years}
\item{binges}{Number of binge drinking episodes}
\item{totdrinks}{Total number of drinks consumed}
\item{tothours}{Total hours spent drinking}
\item{x}{Price point for the purchase task}
\item{y}{Number of drinks participant would purchase at price x}
}
}
\usage{
apt_full
}
\description{
A larger dataset containing alcohol purchase task data with demographic covariates.
Suitable for testing hurdle models and mixed-effects models with covariates.
}
\examples{
\donttest{
data(apt_full)
# Use a subset for quick demonstration
apt_sub <- apt_full[apt_full$id \%in\% unique(apt_full$id)[1:20], ]
fit <- fit_demand_hurdle(apt_sub, y_var = "y", x_var = "x", id_var = "id")
summary(fit)
}

}
\keyword{datasets}
