% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-comparison.R
\name{anova.beezdemand_nlme}
\alias{anova.beezdemand_nlme}
\title{ANOVA Method for NLME Demand Models}
\usage{
\method{anova}{beezdemand_nlme}(object, ...)
}
\arguments{
\item{object}{A \code{beezdemand_nlme} model.}

\item{...}{Additional \code{beezdemand_nlme} models to compare.}
}
\value{
An object of class \code{anova.beezdemand} containing model comparison statistics.
}
\description{
Compare nested NLME demand models using likelihood ratio tests.
}
\details{
For NLME models, this method delegates to \code{nlme::anova.lme()} on the
underlying model objects when possible.
}
\examples{
\donttest{
data(ko)
fit1 <- fit_demand_mixed(ko, y_var = "y_ll4", x_var = "x",
                         id_var = "monkey", equation_form = "zben",
                         random_effects = Q0 ~ 1)
fit2 <- fit_demand_mixed(ko, y_var = "y_ll4", x_var = "x",
                         id_var = "monkey", equation_form = "zben",
                         random_effects = Q0 + alpha ~ 1)
anova(fit1, fit2)
}

}
