% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-comparison.R
\name{anova.beezdemand_hurdle}
\alias{anova.beezdemand_hurdle}
\title{ANOVA Method for Hurdle Demand Models}
\usage{
\method{anova}{beezdemand_hurdle}(object, ...)
}
\arguments{
\item{object}{A \code{beezdemand_hurdle} model.}

\item{...}{Additional \code{beezdemand_hurdle} models to compare.}
}
\value{
An object of class \code{anova.beezdemand} containing:
\describe{
\item{table}{Data frame with model comparison statistics}
\item{lrt}{Likelihood ratio test results}
}
}
\description{
Compare nested hurdle demand models using likelihood ratio tests.
}
\details{
All models must be fit to the same data. Models are ordered by degrees of
freedom, and sequential likelihood ratio tests are performed.
}
\examples{
\donttest{
data(apt)
fit2 <- fit_demand_hurdle(apt, y_var = "y", x_var = "x", id_var = "id",
                          random_effects = c("zeros", "q0"))
fit3 <- fit_demand_hurdle(apt, y_var = "y", x_var = "x", id_var = "id",
                          random_effects = c("zeros", "q0", "alpha"))
anova(fit2, fit3)
}

}
