% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{SimulateDemand}
\alias{SimulateDemand}
\title{Simulate Demand Data}
\usage{
SimulateDemand(nruns = 10, setparams, sdindex, x, outdir = NULL, fn = NULL)
}
\arguments{
\item{nruns}{Number of runs. Default value is 10}

\item{setparams}{A 6x1 matrix (or 6 element vector) containing (in order) mean log10alpha, sd log10alpha, mean log10q0, sd log10q0, k, sd of consumption values across all prices}

\item{sdindex}{A vector of n length of sd consumption values for n prices}

\item{x}{A vector of n prices}

\item{outdir}{Optional. Directory to save results. Must end with a "/"}

\item{fn}{Optional. Filename of saved RData object}
}
\value{
Invisibly a list consisting of: rounded consumption values, unrounded consumption values, simulation parameters, and inState and outState of seeds.
}
\description{
Simulate demand data
}
\details{
Generates and saves simulated datasets in the manner specified in Koffarnus, Franck, Stein, & Bickel (2015).
}
\examples{
## set values
setparams <- vector(length = 4)
setparams <- c(-2.5547, .702521, 1.239893, .320221, 3.096, 1.438231)
names(setparams) <- c("alphalm", "alphalsd", "q0lm", "q0lsd", "k", "yvalssd")
sdindex <- c(2.1978, 1.9243, 1.5804, 1.2465, 0.8104, 0.1751, 0.0380, 0.0270)
x <- c(.1, 1, 3, 10, 30, 100, 300, 1000)
set.seed(1234)
sim <- SimulateDemand(nruns = 1, setparams = setparams, sdindex = sdindex, x = x)
sim
}
\author{
Brent Kaplan \href{mailto:bkaplan.ku@gmail.com}{bkaplan.ku@gmail.com}
}
