% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{PlotCurves}
\alias{PlotCurves}
\title{Plot Curves}
\usage{
PlotCurves(dat, outdir = NULL, device = "png", ending = NULL, ask = TRUE, ...)
}
\arguments{
\item{dat}{FitCurves object with 4 elements (dfres, newdats, adfs, fits)}

\item{outdir}{Directory where plots are saved}

\item{device}{Type of file. Default is "png". Can be "pdf"}

\item{ending}{Optional. Can specify to only plot through a certain number of datasets}

\item{ask}{Can view plots one by one. If TRUE, plots will not save}

\item{...}{Pass arguments to PlotCurve (for example yscale = c("log", "linear"))}
}
\value{
Nothing
}
\description{
Creates plots
}
\details{
Creates and saves plots of individual demand curves
}
\examples{
## Interactively view plots from output from FitCurves
if (interactive()) {
  fc <- FitCurves(apt, "hs", k = 2, detailed = TRUE)
  PlotCurves(fc, ask = TRUE)
}
}
\author{
Brent Kaplan \href{mailto:bkaplan.ku@gmail.com}{bkaplan.ku@gmail.com}, Shawn Gilroy \href{mailto:shawn.gilroy@temple.edu}{shawn.gilroy@temple.edu}
}
