% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{PlotCurve}
\alias{PlotCurve}
\title{Plot Curve}
\usage{
PlotCurve(adf, dfrow, newdats, yscale = "log", style = c("modern", "apa"))
}
\arguments{
\item{adf}{Data frame (long form) of purchase task data.}

\item{dfrow}{A row of results from FitCurves}

\item{newdats}{A newdat dataframe from FitCurves}

\item{yscale}{Scaling of y axis. Default is "log". Can also take "linear"}

\item{style}{Plot styling, passed to \code{theme_beezdemand()}.}
}
\value{
ggplot2 graphical object
}
\description{
Creates a single plot object
}
\details{
Creates individual demand curves
}
\examples{
## Creates a single plot from elements of an object created by FitCurves
if (interactive()) {
  fc <- FitCurves(apt, "hs", k = 2, detailed = TRUE)
  PlotCurve(fc$adfs[[1]], fc$dfres[1, ], fc$newdats[[1]])
}
}
\author{
Shawn Gilroy \href{mailto:shawn.gilroy@temple.edu}{shawn.gilroy@temple.edu}
}
