% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyze.R
\name{GetSharedK}
\alias{GetSharedK}
\title{Get Shared K}
\usage{
GetSharedK(dat, equation, sharecol = "group")
}
\arguments{
\item{dat}{Dataframe (longform)}

\item{equation}{Character vector. Accepts either "hs" or "koff"}

\item{sharecol}{Character for column to find shared k. Default to "group" but can loop based on id.}
}
\value{
Numeric value of shared k
}
\description{
Finds shared k among selected datasets using global regression
}
\details{
Uses global regression to fit a shared k among datasets. Assumes the dataset is in its final form. Used within FitCurves
}
\examples{
## Find a shared k value across datasets indicated by id
\donttest{
GetSharedK(apt, "hs", sharecol = "id")
}
}
\author{
Brent Kaplan \href{mailto:bkaplan.ku@gmail.com}{bkaplan.ku@gmail.com} Shawn P Gilroy \href{mailto:shawn.gilroy@temple.edu}{shawn.gilroy@temple.edu}
}
