% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyze.R
\name{FitCurves}
\alias{FitCurves}
\title{FitCurves}
\usage{
FitCurves(
  dat,
  equation,
  k,
  agg = NULL,
  detailed = FALSE,
  xcol = "x",
  ycol = "y",
  idcol = "id",
  groupcol = NULL,
  lobound,
  hibound,
  constrainq0 = NULL,
  startq0 = NULL,
  startalpha = NULL,
  param_space = c("natural", "log10")
)
}
\arguments{
\item{dat}{data frame (long form) of purchase task data.}

\item{equation}{Character vector of length one. Accepts either "hs" for Hursh and Silberberg (2008) or "koff" for Koffarnus, Franck, Stein, and Bickel (2015).}

\item{k}{A numeric (or character) vector of length one. Reflects the range of consumption in log10 units. If none provided, k will be calculated based on the max/min of the entire sample + .5. If k = "ind", k will be calculated per individual using max/min + .5. If k = "fit", k will be a free parameter on an individual basis. If k = "range", k will be calculated based on the max/min of the entire sample + .5.}

\item{agg}{Character vector of length one accepts either "Mean" or "Pooled". If not NULL (default), data will be aggregrated appropriately and analyzed in the specified way.}

\item{detailed}{If TRUE, output will be a 3 element list including (1) dataframe of results, (2) list of model objects, (3) list of individual dataframes used in fitting. Default value is FALSE, which returns only the dataframe of results.}

\item{xcol}{The column name that should be treated as "x" data}

\item{ycol}{The column name that should be treated as "y" data}

\item{idcol}{The column name that should be treated as dataset identifier}

\item{groupcol}{The column name that should be treated as the groups}

\item{lobound}{Optional. A named vector of length 2 ("q0", "alpha") or 3 ("q0", "k", "alpha"), the latter length if k = "fit", specifying the lower bounds.}

\item{hibound}{Optional. A named vector of length 2 ("q0", "alpha") or 3 ("q0", "k", "alpha"), the latter length if k = "fit", specifying the upper bounds.}

\item{constrainq0}{Optional. A number that will be used to constrain Q0 in the fitting process. Currently experimental and only works with a fixed k value.}

\item{startq0}{Optional. A number that will be used to start Q0 in the fitting process. Currently experimental.}

\item{startalpha}{Optional. A number that will be used to start Alpha in the fitting process. Currently experimental.}

\item{param_space}{Character. One of "natural" (default) or "log10". Specifies whether parameters (Q0, alpha) are estimated in natural space or log10-transformed space.}
}
\value{
If detailed == FALSE (default), a dataframe of results. If detailed == TRUE, a 3 element list consisting of (1) dataframe of results, (2) list of model objects, (3) list of individual dataframes used in fitting
}
\description{
Analyzes purchase task data
}
\details{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}

\code{FitCurves()} has been superseded by \code{\link[=fit_demand_fixed]{fit_demand_fixed()}}, which provides a
modern S3 interface with standardized methods (\code{summary()}, \code{tidy()},
\code{glance()}, \code{predict()}). \code{FitCurves()} will continue to work but is no
longer recommended for new code. See \code{vignette("migration-guide")} for
migration instructions.
}
\examples{
## Analyze using Hursh & Silberberg, 2008 equation with a k fixed to 2
FitCurves(apt[sample(apt$id, 5), ], "hs", k = 2)
}
\seealso{
\code{\link[=fit_demand_fixed]{fit_demand_fixed()}} for the modern interface
}
\author{
Brent Kaplan \href{mailto:bkaplan.ku@gmail.com}{bkaplan.ku@gmail.com} Shawn Gilroy \href{mailto:shawn.gilroy@temple.edu}{shawn.gilroy@temple.edu}
}
