// Generated by rstantools.  Do not edit by hand.

/*
    bclogit is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    bclogit is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with bclogit.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.32.2
#include <stan/model/model_header.hpp>
namespace model_mvn_logistic_Hybrid_namespace {
using stan::model::model_base_crtp;
using namespace stan::math;
stan::math::profile_map profiles__;
static constexpr std::array<const char*, 36> locations_array__ =
  {" (found before start of program)",
  " (in 'mvn_logistic_Hybrid', line 15, column 2 to column 14)",
  " (in 'mvn_logistic_Hybrid', line 16, column 2 to column 14)",
  " (in 'mvn_logistic_Hybrid', line 17, column 2 to column 18)",
  " (in 'mvn_logistic_Hybrid', line 22, column 2 to column 51)",
  " (in 'mvn_logistic_Hybrid', line 25, column 2 to column 30)",
  " (in 'mvn_logistic_Hybrid', line 26, column 2 to column 19)",
  " (in 'mvn_logistic_Hybrid', line 28, column 9 to column 10)",
  " (in 'mvn_logistic_Hybrid', line 28, column 2 to column 46)",
  " (in 'mvn_logistic_Hybrid', line 29, column 9 to column 10)",
  " (in 'mvn_logistic_Hybrid', line 29, column 2 to column 31)",
  " (in 'mvn_logistic_Hybrid', line 30, column 2 to column 16)",
  " (in 'mvn_logistic_Hybrid', line 33, column 4 to column 46)",
  " (in 'mvn_logistic_Hybrid', line 31, column 17 to line 34, column 3)",
  " (in 'mvn_logistic_Hybrid', line 31, column 2 to line 34, column 3)",
  " (in 'mvn_logistic_Hybrid', line 36, column 2 to column 28)",
  " (in 'mvn_logistic_Hybrid', line 38, column 2 to column 27)",
  " (in 'mvn_logistic_Hybrid', line 2, column 2 to column 17)",
  " (in 'mvn_logistic_Hybrid', line 3, column 2 to column 17)",
  " (in 'mvn_logistic_Hybrid', line 4, column 26 to column 27)",
  " (in 'mvn_logistic_Hybrid', line 4, column 2 to column 29)",
  " (in 'mvn_logistic_Hybrid', line 5, column 9 to column 10)",
  " (in 'mvn_logistic_Hybrid', line 5, column 2 to column 15)",
  " (in 'mvn_logistic_Hybrid', line 6, column 9 to column 10)",
  " (in 'mvn_logistic_Hybrid', line 6, column 12 to column 13)",
  " (in 'mvn_logistic_Hybrid', line 6, column 2 to column 17)",
  " (in 'mvn_logistic_Hybrid', line 8, column 9 to column 10)",
  " (in 'mvn_logistic_Hybrid', line 8, column 2 to column 17)",
  " (in 'mvn_logistic_Hybrid', line 9, column 9 to column 10)",
  " (in 'mvn_logistic_Hybrid', line 9, column 12 to column 13)",
  " (in 'mvn_logistic_Hybrid', line 9, column 2 to column 23)",
  " (in 'mvn_logistic_Hybrid', line 12, column 9 to column 10)",
  " (in 'mvn_logistic_Hybrid', line 12, column 12 to column 13)",
  " (in 'mvn_logistic_Hybrid', line 12, column 2 to column 49)",
  " (in 'mvn_logistic_Hybrid', line 16, column 9 to column 10)",
  " (in 'mvn_logistic_Hybrid', line 22, column 9 to column 10)"};
#include <stan_meta_header.hpp>
class model_mvn_logistic_Hybrid final : public model_base_crtp<model_mvn_logistic_Hybrid> {
private:
  int N;
  int P;
  std::vector<int> y;
  Eigen::Matrix<double,-1,1> xw_data__;
  Eigen::Matrix<double,-1,-1> X_data__;
  Eigen::Matrix<double,-1,1> mu_A_data__;
  Eigen::Matrix<double,-1,-1> Sigma_A_data__;
  Eigen::Matrix<double,-1,-1> L_A_data__;
  Eigen::Map<Eigen::Matrix<double,-1,1>> xw{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,-1>> X{nullptr, 0, 0};
  Eigen::Map<Eigen::Matrix<double,-1,1>> mu_A{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,-1>> Sigma_A{nullptr, 0, 0};
  Eigen::Map<Eigen::Matrix<double,-1,-1>> L_A{nullptr, 0, 0};
public:
  ~model_mvn_logistic_Hybrid() {}
  model_mvn_logistic_Hybrid(stan::io::var_context& context__, unsigned int
                            random_seed__ = 0, std::ostream*
                            pstream__ = nullptr) : model_base_crtp(0) {
    int current_statement__ = 0;
    using local_scalar_t__ = double;
    boost::ecuyer1988 base_rng__ =
      stan::services::util::create_rng(random_seed__, 0);
    // suppress unused var warning
    (void) base_rng__;
    static constexpr const char* function__ =
      "model_mvn_logistic_Hybrid_namespace::model_mvn_logistic_Hybrid";
    // suppress unused var warning
    (void) function__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      current_statement__ = 17;
      context__.validate_dims("data initialization", "N", "int",
        std::vector<size_t>{});
      N = std::numeric_limits<int>::min();
      current_statement__ = 17;
      N = context__.vals_i("N")[(1 - 1)];
      current_statement__ = 17;
      stan::math::check_greater_or_equal(function__, "N", N, 0);
      current_statement__ = 18;
      context__.validate_dims("data initialization", "P", "int",
        std::vector<size_t>{});
      P = std::numeric_limits<int>::min();
      current_statement__ = 18;
      P = context__.vals_i("P")[(1 - 1)];
      current_statement__ = 18;
      stan::math::check_greater_or_equal(function__, "P", P, 0);
      current_statement__ = 19;
      stan::math::validate_non_negative_index("y", "N", N);
      current_statement__ = 20;
      context__.validate_dims("data initialization", "y", "int",
        std::vector<size_t>{static_cast<size_t>(N)});
      y = std::vector<int>(N, std::numeric_limits<int>::min());
      current_statement__ = 20;
      y = context__.vals_i("y");
      current_statement__ = 20;
      stan::math::check_greater_or_equal(function__, "y", y, 0);
      current_statement__ = 20;
      stan::math::check_less_or_equal(function__, "y", y, 1);
      current_statement__ = 21;
      stan::math::validate_non_negative_index("xw", "N", N);
      current_statement__ = 22;
      context__.validate_dims("data initialization", "xw", "double",
        std::vector<size_t>{static_cast<size_t>(N)});
      xw_data__ = Eigen::Matrix<double,-1,1>::Constant(N,
                    std::numeric_limits<double>::quiet_NaN());
      new (&xw) Eigen::Map<Eigen::Matrix<double,-1,1>>(xw_data__.data(), N);
      {
        std::vector<local_scalar_t__> xw_flat__;
        current_statement__ = 22;
        xw_flat__ = context__.vals_r("xw");
        current_statement__ = 22;
        pos__ = 1;
        current_statement__ = 22;
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          current_statement__ = 22;
          stan::model::assign(xw, xw_flat__[(pos__ - 1)],
            "assigning variable xw", stan::model::index_uni(sym1__));
          current_statement__ = 22;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 23;
      stan::math::validate_non_negative_index("X", "N", N);
      current_statement__ = 24;
      stan::math::validate_non_negative_index("X", "P", P);
      current_statement__ = 25;
      context__.validate_dims("data initialization", "X", "double",
        std::vector<size_t>{static_cast<size_t>(N), static_cast<size_t>(P)});
      X_data__ = Eigen::Matrix<double,-1,-1>::Constant(N, P,
                   std::numeric_limits<double>::quiet_NaN());
      new (&X) Eigen::Map<Eigen::Matrix<double,-1,-1>>(X_data__.data(), N, P);
      {
        std::vector<local_scalar_t__> X_flat__;
        current_statement__ = 25;
        X_flat__ = context__.vals_r("X");
        current_statement__ = 25;
        pos__ = 1;
        current_statement__ = 25;
        for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
          current_statement__ = 25;
          for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
            current_statement__ = 25;
            stan::model::assign(X, X_flat__[(pos__ - 1)],
              "assigning variable X", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 25;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 26;
      stan::math::validate_non_negative_index("mu_A", "P", P);
      current_statement__ = 27;
      context__.validate_dims("data initialization", "mu_A", "double",
        std::vector<size_t>{static_cast<size_t>(P)});
      mu_A_data__ = Eigen::Matrix<double,-1,1>::Constant(P,
                      std::numeric_limits<double>::quiet_NaN());
      new (&mu_A) Eigen::Map<Eigen::Matrix<double,-1,1>>(mu_A_data__.data(),
        P);
      {
        std::vector<local_scalar_t__> mu_A_flat__;
        current_statement__ = 27;
        mu_A_flat__ = context__.vals_r("mu_A");
        current_statement__ = 27;
        pos__ = 1;
        current_statement__ = 27;
        for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
          current_statement__ = 27;
          stan::model::assign(mu_A, mu_A_flat__[(pos__ - 1)],
            "assigning variable mu_A", stan::model::index_uni(sym1__));
          current_statement__ = 27;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 28;
      stan::math::validate_non_negative_index("Sigma_A", "P", P);
      current_statement__ = 29;
      stan::math::validate_non_negative_index("Sigma_A", "P", P);
      current_statement__ = 30;
      context__.validate_dims("data initialization", "Sigma_A", "double",
        std::vector<size_t>{static_cast<size_t>(P), static_cast<size_t>(P)});
      Sigma_A_data__ = Eigen::Matrix<double,-1,-1>::Constant(P, P,
                         std::numeric_limits<double>::quiet_NaN());
      new (&Sigma_A)
        Eigen::Map<Eigen::Matrix<double,-1,-1>>(Sigma_A_data__.data(), P, P);
      {
        std::vector<local_scalar_t__> Sigma_A_flat__;
        current_statement__ = 30;
        Sigma_A_flat__ = context__.vals_r("Sigma_A");
        current_statement__ = 30;
        pos__ = 1;
        current_statement__ = 30;
        for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
          current_statement__ = 30;
          for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
            current_statement__ = 30;
            stan::model::assign(Sigma_A, Sigma_A_flat__[(pos__ - 1)],
              "assigning variable Sigma_A", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 30;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 31;
      stan::math::validate_non_negative_index("L_A", "P", P);
      current_statement__ = 32;
      stan::math::validate_non_negative_index("L_A", "P", P);
      current_statement__ = 33;
      L_A_data__ = Eigen::Matrix<double,-1,-1>::Constant(P, P,
                     std::numeric_limits<double>::quiet_NaN());
      new (&L_A) Eigen::Map<Eigen::Matrix<double,-1,-1>>(L_A_data__.data(),
        P, P);
      current_statement__ = 33;
      stan::model::assign(L_A, stan::math::cholesky_decompose(Sigma_A),
        "assigning variable L_A");
      current_statement__ = 34;
      stan::math::validate_non_negative_index("z", "P", P);
      current_statement__ = 35;
      stan::math::validate_non_negative_index("beta_nuis", "P", P);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    num_params_r__ = 1 + P + 1;
  }
  inline std::string model_name() const final {
    return "model_mvn_logistic_Hybrid";
  }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.32.2",
             "stancflags = --allow-undefined"};
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI,
            stan::require_vector_like_t<VecR>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR>
  log_prob_impl(VecR& params_r__, VecI& params_i__, std::ostream*
                pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    static constexpr const char* function__ =
      "model_mvn_logistic_Hybrid_namespace::log_prob";
    // suppress unused var warning
    (void) function__;
    try {
      local_scalar_t__ beta_w = DUMMY_VAR__;
      current_statement__ = 1;
      beta_w = in__.template read<local_scalar_t__>();
      Eigen::Matrix<local_scalar_t__,-1,1> z =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(P, DUMMY_VAR__);
      current_statement__ = 2;
      z = in__.template read<Eigen::Matrix<local_scalar_t__,-1,1>>(P);
      local_scalar_t__ g = DUMMY_VAR__;
      current_statement__ = 3;
      g = in__.template read_constrain_lb<local_scalar_t__, jacobian__>(0,
            lp__);
      Eigen::Matrix<local_scalar_t__,-1,1> beta_nuis =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(P, DUMMY_VAR__);
      current_statement__ = 4;
      stan::model::assign(beta_nuis,
        stan::math::add(mu_A,
          stan::math::multiply(stan::math::sqrt(g),
            stan::math::multiply(L_A, z))), "assigning variable beta_nuis");
      {
        current_statement__ = 5;
        lp_accum__.add(stan::math::inv_gamma_lpdf<propto__>(g, 0.5, (N / 2.0)));
        current_statement__ = 6;
        lp_accum__.add(stan::math::std_normal_lpdf<propto__>(z));
        current_statement__ = 7;
        stan::math::validate_non_negative_index("eta", "N", N);
        Eigen::Matrix<local_scalar_t__,-1,1> eta =
          Eigen::Matrix<local_scalar_t__,-1,1>::Constant(N, DUMMY_VAR__);
        current_statement__ = 8;
        stan::model::assign(eta,
          stan::math::add(stan::math::multiply(xw, beta_w),
            stan::math::multiply(X, beta_nuis)), "assigning variable eta");
        current_statement__ = 9;
        stan::math::validate_non_negative_index("p", "N", N);
        Eigen::Matrix<local_scalar_t__,-1,1> p =
          Eigen::Matrix<local_scalar_t__,-1,1>::Constant(N, DUMMY_VAR__);
        current_statement__ = 10;
        stan::model::assign(p, stan::math::inv_logit(eta),
          "assigning variable p");
        local_scalar_t__ I_ww = DUMMY_VAR__;
        current_statement__ = 11;
        I_ww = 0;
        current_statement__ = 14;
        for (int i = 1; i <= N; ++i) {
          current_statement__ = 12;
          I_ww = (I_ww +
            ((stan::math::square(
                stan::model::rvalue(xw, "xw", stan::model::index_uni(i)))
            * stan::model::rvalue(p, "p", stan::model::index_uni(i))) * (1 -
            stan::model::rvalue(p, "p", stan::model::index_uni(i)))));
        }
        current_statement__ = 15;
        lp_accum__.add((0.5 * stan::math::log(I_ww)));
        current_statement__ = 16;
        lp_accum__.add(stan::math::bernoulli_logit_lpmf<propto__>(y, eta));
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
  }
  template <typename RNG, typename VecR, typename VecI, typename VecVar,
            stan::require_vector_like_vt<std::is_floating_point,
            VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral,
            VecI>* = nullptr, stan::require_vector_vt<std::is_floating_point,
            VecVar>* = nullptr>
  inline void
  write_array_impl(RNG& base_rng__, VecR& params_r__, VecI& params_i__,
                   VecVar& vars__, const bool
                   emit_transformed_parameters__ = true, const bool
                   emit_generated_quantities__ = true, std::ostream*
                   pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    static constexpr bool propto__ = true;
    // suppress unused var warning
    (void) propto__;
    double lp__ = 0.0;
    // suppress unused var warning
    (void) lp__;
    int current_statement__ = 0;
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    constexpr bool jacobian__ = false;
    static constexpr const char* function__ =
      "model_mvn_logistic_Hybrid_namespace::write_array";
    // suppress unused var warning
    (void) function__;
    try {
      double beta_w = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 1;
      beta_w = in__.template read<local_scalar_t__>();
      Eigen::Matrix<double,-1,1> z =
        Eigen::Matrix<double,-1,1>::Constant(P,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 2;
      z = in__.template read<Eigen::Matrix<local_scalar_t__,-1,1>>(P);
      double g = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 3;
      g = in__.template read_constrain_lb<local_scalar_t__, jacobian__>(0,
            lp__);
      Eigen::Matrix<double,-1,1> beta_nuis =
        Eigen::Matrix<double,-1,1>::Constant(P,
          std::numeric_limits<double>::quiet_NaN());
      out__.write(beta_w);
      out__.write(z);
      out__.write(g);
      if (stan::math::logical_negation(
            (stan::math::primitive_value(emit_transformed_parameters__) ||
            stan::math::primitive_value(emit_generated_quantities__)))) {
        return ;
      }
      current_statement__ = 4;
      stan::model::assign(beta_nuis,
        stan::math::add(mu_A,
          stan::math::multiply(stan::math::sqrt(g),
            stan::math::multiply(L_A, z))), "assigning variable beta_nuis");
      if (emit_transformed_parameters__) {
        out__.write(beta_nuis);
      }
      if (stan::math::logical_negation(emit_generated_quantities__)) {
        return ;
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, typename VecI,
            stan::require_vector_t<VecVar>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void
  unconstrain_array_impl(const VecVar& params_r__, const VecI& params_i__,
                         VecVar& vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      local_scalar_t__ beta_w = DUMMY_VAR__;
      current_statement__ = 1;
      beta_w = in__.read<local_scalar_t__>();
      out__.write(beta_w);
      Eigen::Matrix<local_scalar_t__,-1,1> z =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(P, DUMMY_VAR__);
      current_statement__ = 2;
      stan::model::assign(z,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,1>>(P),
        "assigning variable z");
      out__.write(z);
      local_scalar_t__ g = DUMMY_VAR__;
      current_statement__ = 3;
      g = in__.read<local_scalar_t__>();
      out__.write_free_lb(0, g);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, stan::require_vector_t<VecVar>* = nullptr>
  inline void
  transform_inits_impl(const stan::io::var_context& context__, VecVar&
                       vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      current_statement__ = 1;
      context__.validate_dims("parameter initialization", "beta_w", "double",
        std::vector<size_t>{});
      current_statement__ = 2;
      context__.validate_dims("parameter initialization", "z", "double",
        std::vector<size_t>{static_cast<size_t>(P)});
      current_statement__ = 3;
      context__.validate_dims("parameter initialization", "g", "double",
        std::vector<size_t>{});
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      local_scalar_t__ beta_w = DUMMY_VAR__;
      current_statement__ = 1;
      beta_w = context__.vals_r("beta_w")[(1 - 1)];
      out__.write(beta_w);
      Eigen::Matrix<local_scalar_t__,-1,1> z =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(P, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> z_flat__;
        current_statement__ = 2;
        z_flat__ = context__.vals_r("z");
        current_statement__ = 2;
        pos__ = 1;
        current_statement__ = 2;
        for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
          current_statement__ = 2;
          stan::model::assign(z, z_flat__[(pos__ - 1)],
            "assigning variable z", stan::model::index_uni(sym1__));
          current_statement__ = 2;
          pos__ = (pos__ + 1);
        }
      }
      out__.write(z);
      local_scalar_t__ g = DUMMY_VAR__;
      current_statement__ = 3;
      g = context__.vals_r("g")[(1 - 1)];
      out__.write_free_lb(0, g);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  inline void
  get_param_names(std::vector<std::string>& names__, const bool
                  emit_transformed_parameters__ = true, const bool
                  emit_generated_quantities__ = true) const {
    names__ = std::vector<std::string>{"beta_w", "z", "g"};
    if (emit_transformed_parameters__) {
      std::vector<std::string> temp{"beta_nuis"};
      names__.reserve(names__.size() + temp.size());
      names__.insert(names__.end(), temp.begin(), temp.end());
    }
    if (emit_generated_quantities__) {}
  }
  inline void
  get_dims(std::vector<std::vector<size_t>>& dimss__, const bool
           emit_transformed_parameters__ = true, const bool
           emit_generated_quantities__ = true) const {
    dimss__ = std::vector<std::vector<size_t>>{std::vector<size_t>{},
                std::vector<size_t>{static_cast<size_t>(P)},
                std::vector<size_t>{}};
    if (emit_transformed_parameters__) {
      std::vector<std::vector<size_t>>
        temp{std::vector<size_t>{static_cast<size_t>(P)}};
      dimss__.reserve(dimss__.size() + temp.size());
      dimss__.insert(dimss__.end(), temp.begin(), temp.end());
    }
    if (emit_generated_quantities__) {}
  }
  inline void
  constrained_param_names(std::vector<std::string>& param_names__, bool
                          emit_transformed_parameters__ = true, bool
                          emit_generated_quantities__ = true) const final {
    param_names__.emplace_back(std::string() + "beta_w");
    for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
      param_names__.emplace_back(std::string() + "z" + '.' +
        std::to_string(sym1__));
    }
    param_names__.emplace_back(std::string() + "g");
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
        param_names__.emplace_back(std::string() + "beta_nuis" + '.' +
          std::to_string(sym1__));
      }
    }
    if (emit_generated_quantities__) {}
  }
  inline void
  unconstrained_param_names(std::vector<std::string>& param_names__, bool
                            emit_transformed_parameters__ = true, bool
                            emit_generated_quantities__ = true) const final {
    param_names__.emplace_back(std::string() + "beta_w");
    for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
      param_names__.emplace_back(std::string() + "z" + '.' +
        std::to_string(sym1__));
    }
    param_names__.emplace_back(std::string() + "g");
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
        param_names__.emplace_back(std::string() + "beta_nuis" + '.' +
          std::to_string(sym1__));
      }
    }
    if (emit_generated_quantities__) {}
  }
  inline std::string get_constrained_sizedtypes() const {
    return std::string("[{\"name\":\"beta_w\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"z\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(P) + "},\"block\":\"parameters\"},{\"name\":\"g\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"beta_nuis\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(P) + "},\"block\":\"transformed_parameters\"}]");
  }
  inline std::string get_unconstrained_sizedtypes() const {
    return std::string("[{\"name\":\"beta_w\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"z\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(P) + "},\"block\":\"parameters\"},{\"name\":\"g\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"beta_nuis\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(P) + "},\"block\":\"transformed_parameters\"}]");
  }
  // Begin method overload boilerplate
  template <typename RNG> inline void
  write_array(RNG& base_rng, Eigen::Matrix<double,-1,1>& params_r,
              Eigen::Matrix<double,-1,1>& vars, const bool
              emit_transformed_parameters = true, const bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = ((1 + P) + 1);
    const size_t num_transformed = emit_transformed_parameters * (P);
    const size_t num_gen_quantities = emit_generated_quantities * (0);
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    std::vector<int> params_i;
    vars = Eigen::Matrix<double,-1,1>::Constant(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <typename RNG> inline void
  write_array(RNG& base_rng, std::vector<double>& params_r, std::vector<int>&
              params_i, std::vector<double>& vars, bool
              emit_transformed_parameters = true, bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = ((1 + P) + 1);
    const size_t num_transformed = emit_transformed_parameters * (P);
    const size_t num_gen_quantities = emit_generated_quantities * (0);
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    vars = std::vector<double>(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(Eigen::Matrix<T_,-1,1>& params_r, std::ostream* pstream = nullptr) const {
    Eigen::Matrix<int,-1,1> params_i;
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(std::vector<T_>& params_r, std::vector<int>& params_i,
           std::ostream* pstream = nullptr) const {
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  inline void
  transform_inits(const stan::io::var_context& context,
                  Eigen::Matrix<double,-1,1>& params_r, std::ostream*
                  pstream = nullptr) const final {
    std::vector<double> params_r_vec(params_r.size());
    std::vector<int> params_i;
    transform_inits(context, params_i, params_r_vec, pstream);
    params_r = Eigen::Map<Eigen::Matrix<double,-1,1>>(params_r_vec.data(),
                 params_r_vec.size());
  }
  inline void
  transform_inits(const stan::io::var_context& context, std::vector<int>&
                  params_i, std::vector<double>& vars, std::ostream*
                  pstream__ = nullptr) const {
    vars.resize(num_params_r__);
    transform_inits_impl(context, vars, pstream__);
  }
  inline void
  unconstrain_array(const std::vector<double>& params_constrained,
                    std::vector<double>& params_unconstrained, std::ostream*
                    pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = std::vector<double>(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
  inline void
  unconstrain_array(const Eigen::Matrix<double,-1,1>& params_constrained,
                    Eigen::Matrix<double,-1,1>& params_unconstrained,
                    std::ostream* pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = Eigen::Matrix<double,-1,1>::Constant(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
};
}
using stan_model = model_mvn_logistic_Hybrid_namespace::model_mvn_logistic_Hybrid;
#ifndef USING_R
// Boilerplate
stan::model::model_base&
new_model(stan::io::var_context& data_context, unsigned int seed,
          std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_mvn_logistic_Hybrid_namespace::profiles__;
}
#endif
#endif
