% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_details.R
\name{get_details.fujikawa}
\alias{get_details.fujikawa}
\title{Get Details of a Basket Trial Simulation with Fujikawa's Design}
\usage{
\method{get_details}{fujikawa}(
  design,
  n,
  p1 = NULL,
  lambda,
  level = 0.95,
  epsilon,
  tau,
  logbase = 2,
  iter = 1000,
  data = NULL,
  use_future = FALSE,
  weight_fun = NULL,
  weight_params = list(epsilon = epsilon, tau = tau, logbase = logbase),
  ...
)
}
\arguments{
\item{design}{An object of class \code{fujikawa}.}

\item{n}{The sample sizes of the baskets. A vector must be used for varying sample sizes.}

\item{p1}{Probabilities used for the simulation. If \code{NULL}
then all probabilities are set to p0.}

\item{lambda}{The posterior probability threshold.}

\item{level}{Level of the credibility intervals.}

\item{epsilon}{Tuning parameter that determines the amount of borrowing.
See \code{\link{setup_fujikawa}}).}

\item{tau}{Tuning parameter that determines how similar the baskets
have to be that information is shared. See \code{\link{setup_fujikawa}}).}

\item{logbase}{Tuning parameter. The base of the logarithm that is used to
calculate the Jensen-Shannon divergence.}

\item{iter}{The number of iterations in the simulation. Is ignored if
\code{data} is specified.}

\item{data}{A data matrix with k column with the number of responses for each
basket. Has to be generated with \code{get_data}. If \code{data} is used,
then \code{iter} is ignored.}

\item{use_future}{A logical, should \code{\%dofuture\%} or \code{\%do\%} be used
for the call to \code{foreach}. Default is \code{FALSE} which means that
\code{\%dofuture\%} is not used. \code{\%dofuture\%}
is needed for parallelization. Note that for actually using parallelized
calculations, one needs to activate a \code{future} backend.}

\item{weight_fun}{A function of the form \code{function(design, n, ...)} that
additionally takes the arguments given in \code{weight_params}. If \code{NULL}, the
original weights suggested by Fujikawa are used (based on the Jensen-Shannon
divergence).}

\item{weight_params}{A named list of input parameters (additional to \code{design}
and \code{n}) for the function \code{weight_fun}.}

\item{...}{Further arguments.}
}
\value{
A list containing the rejection probabilities, posterior means,
mean squared errors and mean limits of HDI intervals for all baskets as well
as the family-wise error rate and the experiment-wise power.
}
\description{
Get Details of a Basket Trial Simulation with Fujikawa's Design
}
\examples{
design <- setup_fujikawa(k = 3, p0 = 0.2)

# Equal sample sizes
get_details(design = design, n = 20, p1 = c(0.2, 0.5, 0.5),
  lambda = 0.95, epsilon = 2, tau = 0, iter = 100)

# Unequal sample sizes
get_details(design = design, n = c(15, 20, 25), p1 = c(0.2, 0.5, 0.5),
  lambda = 0.95, epsilon = 2, tau = 0, iter = 100)

# A custom weight function can be defined, e.g.
weight_noshare <- function(design, n, epsilon, tau, logbase){
  n_sum <- n + 1
  return(diag(n_sum))
}
get_details(design = design, n = 20, p1 = c(0.2, 0.5, 0.5), lambda = 0.95,
           epsilon = 2, tau = 0, iter = 1000, weight_fun = weight_noshare)
}
