% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_predictions.R
\name{sample_predictions}
\alias{sample_predictions}
\title{Get a dataframe of multiple draws of only the predicted elements of the
nowcast vector}
\usage{
sample_predictions(
  point_nowcast_matrix,
  reporting_triangle,
  uncertainty_params,
  draws = 1000,
  ...
)
}
\arguments{
\item{point_nowcast_matrix}{Matrix of point nowcast predictions and
observations, with rows representing the reference times and columns
representing the delays.}

\item{reporting_triangle}{A \link{reporting_triangle} object with rows
representing reference times and columns representing delays.
Can be a reporting matrix or incomplete reporting matrix.
Can also be a ragged reporting triangle, where multiple columns are
reported for the same row (e.g., weekly reporting of daily data).}

\item{uncertainty_params}{Vector of uncertainty parameters ordered from
horizon 1 to the maximum horizon. Note that these will be reversed
internally to match the ordering of the \code{point_nowcast_matrix} (where
a horizon of 1 is the last entry).}

\item{draws}{Integer indicating the number of draws of the predicted
nowcast vector to generate. Default is \code{1000}.}

\item{...}{Additional arguments passed to \code{sample_prediction}.}
}
\value{
Dataframe containing the predicted point nowcast vectors indexed by
predicted count (\code{pred_count}), reference date (\code{reference_date}), and
the draw index (\code{draw}). Returns predictions for all reference dates
in the input \code{reporting_triangle} (or fewer if using
\code{ref_time_aggregator}).
}
\description{
Get a dataframe of multiple draws of only the predicted elements of the
nowcast vector
}
\examples{
# Generate point nowcast and uncertainty params from example data
data_as_of <- syn_nssp_df[syn_nssp_df$report_date <= "2026-04-01", ]
rep_tri <- as_reporting_triangle(data_as_of) |>
  truncate_to_delay(max_delay = 5) |>
  tail(n = 10)
point_nowcast_matrix <- estimate_and_apply_delay(rep_tri, n = 10)
reporting_triangle <- apply_reporting_structure(rep_tri)
uncertainty_params <- estimate_uncertainty_retro(
  rep_tri,
  n_history_delay = 8,
  n_retrospective_nowcasts = 2
)
nowcast_pred_draws <- sample_predictions(
  point_nowcast_matrix,
  reporting_triangle,
  uncertainty_params,
  draws = 5
)
nowcast_pred_draws

# Get nowcast pred draws over rolling sum
if (requireNamespace("zoo", quietly = TRUE)) {
  nowcast_pred_draws_rolling_df <- sample_predictions(
    point_nowcast_matrix,
    reporting_triangle,
    uncertainty_params,
    draws = 5,
    ref_time_aggregator = function(x) zoo::rollsum(x, k = 2, align = "right")
  )
  nowcast_pred_draws_rolling_df
}
}
\seealso{
Probabilistic nowcast generation functions
\code{\link{combine_obs_with_pred}()},
\code{\link{sample_nb}()},
\code{\link{sample_nowcast}()},
\code{\link{sample_nowcasts}()},
\code{\link{sample_prediction}()}
}
\concept{generate_probabilistic_nowcasts}
