% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{example_downward_corr_rt}
\alias{example_downward_corr_rt}
\title{Example reporting triangle with downward corrections}
\format{
A \link{reporting_triangle} object with 8 reference dates and 4 delays:
\describe{
\item{reporting_triangle_matrix}{8x4 matrix with negative values at
delay 2}
\item{reference_dates}{8 dates starting from 2024-01-01}
\item{delays_unit}{"days"}
}
}
\usage{
example_downward_corr_rt
}
\description{
A \link{reporting_triangle} object demonstrating how to handle
systematic downward corrections in reporting data.
This represents a realistic case where data quality reviews at delay 2
consistently identify false positives or reclassify cases, producing
negative values at that specific delay.
}
\details{
Use this example to understand:
\itemize{
\item How to work with negative corrections in delay distributions
\item The impact of preprocessing negative values on delay estimation
\item How PMFs and CDFs behave with systematic downward corrections
}
}
\examples{
# View the example triangle with downward corrections
example_downward_corr_rt

# Estimate delay with and without preprocessing
delay_raw <- estimate_delay(example_downward_corr_rt, n = 5)
delay_processed <- estimate_delay(
  preprocess_negative_values(example_downward_corr_rt),
  n = 5
)

# Compare the resulting PMFs
delay_raw
delay_processed
}
\seealso{
\itemize{
\item \link{example_reporting_triangle} for a clean example without corrections
\item \code{\link[=baselinenowcast.reporting_triangle]{baselinenowcast.reporting_triangle()}} specifically the \code{preprocess}
argument for a description of how to remove negative values if desired.
}

Example datasets
\code{\link{example_reporting_triangle}},
\code{\link{germany_covid19_hosp}},
\code{\link{syn_nssp_df}},
\code{\link{syn_nssp_line_list}}
}
\concept{example_data}
\keyword{datasets}
