% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_ChainLadder_triangle.R
\name{as_reporting_triangle.triangle}
\alias{as_reporting_triangle.triangle}
\title{Convert ChainLadder triangle to reporting_triangle format}
\usage{
\method{as_reporting_triangle}{triangle}(data, delays_unit = "days", reference_dates = NULL, ...)
}
\arguments{
\item{data}{A ChainLadder triangle object (class "triangle").}

\item{delays_unit}{Character string specifying the temporal granularity of
the delays. Options are \code{"days"}, \code{"weeks"}, \code{"months"}, \code{"years"}.
Default is \code{"days"}.}

\item{reference_dates}{Vector of dates corresponding to the rows of the
triangle.
If not provided, will attempt to coerce row names to dates.
If row names cannot be coerced to dates and this is not provided,
an error will be raised.}

\item{...}{Additional arguments passed to \code{\link[=as_reporting_triangle.matrix]{as_reporting_triangle.matrix()}}.}
}
\value{
A \link{reporting_triangle} object.
See \linkS4class{reporting_triangle} for details on the structure.
}
\description{
This S3 method converts a ChainLadder triangle object to a
\link{reporting_triangle} object, enabling use of baselinenowcast's nowcasting
methods.
}
\details{
This method converts a ChainLadder triangle back to baselinenowcast's
\link{reporting_triangle} format.
If \code{reference_dates} is not provided, the function will attempt to extract
dates from the triangle's row names.

The ChainLadder package must be installed to use this function.

The conversion uses \code{\link[=as_reporting_triangle.matrix]{as_reporting_triangle.matrix()}} internally after
extracting the matrix from the ChainLadder triangle object.
}
\examples{
\dontshow{if (requireNamespace("ChainLadder", quietly = TRUE)) withAutoprint(\{ # examplesIf}
# Create a reporting triangle
data_as_of_df <- syn_nssp_df[syn_nssp_df$report_date <= "2026-04-01", ]
rep_tri <- as_reporting_triangle(data = data_as_of_df)

# Convert to ChainLadder triangle
cl_triangle <- as_ChainLadder_triangle(rep_tri)

# Convert back to reporting_triangle (seamless round-trip)
# max_delay is inferred from the ChainLadder triangle dimensions
rep_tri_2 <- as_reporting_triangle(data = cl_triangle)
print(rep_tri_2)
\dontshow{\}) # examplesIf}
}
\seealso{
\itemize{
\item \code{\link[=as_ChainLadder_triangle]{as_ChainLadder_triangle()}} for converting to ChainLadder
\item \code{\link[=as_reporting_triangle.matrix]{as_reporting_triangle.matrix()}} for the underlying method
\item \code{\link[=as_reporting_triangle.data.frame]{as_reporting_triangle.data.frame()}} for creating from data frames
}

Reporting triangle construction and validation
\code{\link{[.reporting_triangle}()},
\code{\link{[<-.reporting_triangle}()},
\code{\link{as.data.frame.reporting_triangle}()},
\code{\link{as.matrix.reporting_triangle}()},
\code{\link{as_ChainLadder_triangle}()},
\code{\link{as_reporting_triangle}()},
\code{\link{as_reporting_triangle.data.frame}()},
\code{\link{as_reporting_triangle.matrix}()},
\code{\link{assert_reporting_triangle}()},
\code{\link{get_delays_from_dates}()},
\code{\link{get_delays_unit}()},
\code{\link{get_max_delay}()},
\code{\link{get_mean_delay}()},
\code{\link{get_quantile_delay}()},
\code{\link{get_reference_dates}()},
\code{\link{get_report_dates}()},
\code{\link{get_reporting_structure}()},
\code{\link{head.reporting_triangle}()},
\code{\link{is_reporting_triangle}()},
\code{\link{new_reporting_triangle}()},
\code{\link{print.reporting_triangle}()},
\code{\link{reporting_triangle-class}},
\code{\link{summary.reporting_triangle}()},
\code{\link{tail.reporting_triangle}()},
\code{\link{truncate_to_delay}()},
\code{\link{truncate_to_quantile}()},
\code{\link{validate_reporting_triangle}()}
}
\concept{reporting_triangle}
