% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_reporting_triangle.R
\name{as_reporting_triangle}
\alias{as_reporting_triangle}
\title{Create a \code{reporting_triangle} object}
\usage{
as_reporting_triangle(data, delays_unit = "days", ...)
}
\arguments{
\item{data}{Data to be nowcasted.}

\item{delays_unit}{Character string specifying the temporal granularity of
the delays. Options are \code{"days"}, \code{"weeks"}, \code{"months"}, \code{"years"}.
Default is \code{"days"}.}

\item{...}{Additional arguments passed to methods.}
}
\value{
A \link{reporting_triangle} object
}
\description{
Create a \code{reporting_triangle} object
}
\examples{
# Create a reporting triangle from a data.frame
data_as_of_df <- syn_nssp_df[
  syn_nssp_df$report_date <= "2026-04-01" &
    (syn_nssp_df$report_date - syn_nssp_df$reference_date) <= 25,
]
rt <- as_reporting_triangle(data = data_as_of_df)
rt
}
\seealso{
Reporting triangle construction and validation
\code{\link{[.reporting_triangle}()},
\code{\link{[<-.reporting_triangle}()},
\code{\link{as.data.frame.reporting_triangle}()},
\code{\link{as.matrix.reporting_triangle}()},
\code{\link{as_ChainLadder_triangle}()},
\code{\link{as_reporting_triangle.data.frame}()},
\code{\link{as_reporting_triangle.matrix}()},
\code{\link{as_reporting_triangle.triangle}()},
\code{\link{assert_reporting_triangle}()},
\code{\link{get_delays_from_dates}()},
\code{\link{get_delays_unit}()},
\code{\link{get_max_delay}()},
\code{\link{get_mean_delay}()},
\code{\link{get_quantile_delay}()},
\code{\link{get_reference_dates}()},
\code{\link{get_report_dates}()},
\code{\link{get_reporting_structure}()},
\code{\link{head.reporting_triangle}()},
\code{\link{is_reporting_triangle}()},
\code{\link{new_reporting_triangle}()},
\code{\link{print.reporting_triangle}()},
\code{\link{reporting_triangle-class}},
\code{\link{summary.reporting_triangle}()},
\code{\link{tail.reporting_triangle}()},
\code{\link{truncate_to_delay}()},
\code{\link{truncate_to_quantile}()},
\code{\link{validate_reporting_triangle}()}
}
\concept{reporting_triangle}
