% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply_reporting_structure.R
\name{apply_reporting_structure}
\alias{apply_reporting_structure}
\title{Apply reporting structure to generate a single retrospective reporting
triangle}
\usage{
apply_reporting_structure(
  truncated_reporting_triangle,
  structure = 1,
  validate = TRUE
)
}
\arguments{
\item{truncated_reporting_triangle}{A single truncated reporting_triangle
object. May or may not contain NAs.}

\item{structure}{Integer or vector specifying the reporting structure.
If integer, divides columns evenly by that integer (with last possibly
truncated).  If vector, the sum must not be greater than or equal to the
number of columns. Default is 1 (standard triangular structure).}

\item{validate}{Logical. If TRUE (default), validates the object. Set to
FALSE only when called from functions that already validated.}
}
\value{
A single retrospective reporting triangle matrix with NAs in the
appropriate positions.
}
\description{
This function applies a reporting structure to a truncated reporting triangle
by setting observations to NA row by row from the bottom up based on the
specified structure. It is the singular version of
\code{apply_reporting_structures()}.
}
\examples{
# Standard triangular structure (default)
rep_tri <- apply_reporting_structure(example_reporting_triangle)
rep_tri

# Ragged structure with 2 columns per delay period
rep_ragged <- apply_reporting_structure(example_reporting_triangle, 2)
rep_ragged

# Custom structure with explicit column counts
rep_custom <- apply_reporting_structure(example_reporting_triangle, c(1, 2))
rep_custom
}
\seealso{
Retrospective data generation functions
\code{\link{apply_reporting_structures}()},
\code{\link{truncate_to_row}()},
\code{\link{truncate_to_rows}()}
}
\concept{generate_retrospective_data}
