% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allocate_reference_times.R
\name{allocate_reference_times}
\alias{allocate_reference_times}
\title{Allocate training volume based on combination of defaults and user-specified
values for training volume for delay and uncertainty estimation.}
\usage{
allocate_reference_times(
  reporting_triangle,
  scale_factor = 3,
  prop_delay = 0.5,
  n_min_retro_nowcasts = 2,
  validate = TRUE
)
}
\arguments{
\item{reporting_triangle}{A \link{reporting_triangle} object with rows
representing reference times and columns representing delays.
Can be a reporting matrix or incomplete reporting matrix.
Can also be a ragged reporting triangle, where multiple columns are
reported for the same row (e.g., weekly reporting of daily data).}

\item{scale_factor}{Numeric value indicating the multiplicative factor on
the maximum delay to be used for estimation of delay and uncertainty.
Default is \code{3}.}

\item{prop_delay}{Numeric value <1 indicating what proportion of all
reference times in the reporting triangle to be used for delay
estimation. Default is \code{0.5}.}

\item{n_min_retro_nowcasts}{Integer indicating the minimum number of
reference times needed for uncertainty estimation. Default is \code{2}.}

\item{validate}{Logical. If TRUE (default), validates the object. Set to
FALSE only when called from functions that already validated.}
}
\value{
list of n_history_delay and n_retrospective_nowcasts
}
\description{
Given the reporting triangle and optionally the user-specified
scale factor on the max delay to be used as total reference times and the
proportion of those reference times to be used for delay estimation,
allocate reference times to the number used for delay estimation and the
number used as retrospective nowcasts for uncertainty estimation.

This function implements an algorithm which:
\itemize{
\item if the specified number of reference times
(\code{scale_factor} x \verb{max delay}) is less than or equal to the number of
reference times available in the reporting triangle, split reference times
between delay and uncertainty according to \code{prop_delay}, ensuring that the
minimum requirements for delay and uncertainty estimation are met.
\item if the specified number of reference times is greater than the
number of reference times available in the reporting triangle,
use all the reference times available and satisfy the minimum
requirement for delay estimation and then split the remainder according to
the specified \code{prop_delay}, ensuring that the minimum reference times
for delay and uncertainty estimation are fulfilled.
\item the function errors if the minimum requirements for delay and
uncertainty estimation are not possible from the number of reference times
in the reporting triangle.
}
}
\examples{
# Create a reporting triangle from package data
data_as_of <- syn_nssp_df[syn_nssp_df$report_date <= "2026-04-01", ]
rep_tri <- as_reporting_triangle(data_as_of) |>
  truncate_to_delay(max_delay = 25)

# Use the defaults (scale_factor = 3, prop_delay = 0.5)
ref_time_allocation_default <- allocate_reference_times(rep_tri)
ref_time_allocation_default

# Modify to use less volume and redistribute
ref_time_allocation_alt <- allocate_reference_times(
  reporting_triangle = rep_tri,
  scale_factor = 2,
  prop_delay = 0.6
)
ref_time_allocation_alt
}
\seealso{
High-level workflow wrapper functions
\code{\link{estimate_and_apply_delay}()},
\code{\link{estimate_and_apply_delays}()},
\code{\link{estimate_and_apply_uncertainty}()},
\code{\link{estimate_uncertainty_retro}()}
}
\concept{workflow_wrappers}
