% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1.Stats.R
\docType{data}
\name{barrel_stats}
\alias{barrel_stats}
\alias{stat_barrel}
\alias{stat_barrel_centroid}
\alias{stat_barrel_arrows}
\alias{compute_envfit_vectors}
\alias{stat_barrel_annotate}
\alias{StatBarrel}
\alias{StatBarrelCentroid}
\alias{StatBarrelAnnotate}
\title{Comprehensive Ordination Visualization Layer}
\usage{
stat_barrel(
  mapping = NULL,
  data = NULL,
  geom = "path",
  position = "identity",
  kind = "se",
  conf = 0.95,
  method = c("robust", "classic"),
  show.legend = NA,
  inherit.aes = TRUE,
  geom_type = c("path", "polygon"),
  ...
)

stat_barrel_centroid(
  mapping = NULL,
  data = NULL,
  geom = "point",
  position = "identity",
  method = c("classic", "robust"),
  show.legend = NA,
  inherit.aes = TRUE,
  shape = 3,
  ...
)

stat_barrel_arrows(
  mapping = NULL,
  data = NULL,
  ord,
  matrix,
  geom = "segment",
  position = "identity",
  labels = TRUE,
  labels.color = "black",
  labels.size = 3,
  labels.fontface = "plain",
  show.significant = FALSE,
  p_thresh = 0.05,
  arrow = grid::arrow(length = grid::unit(0.25, "cm")),
  arrow.color = "grey10",
  arrow.linetype = "solid",
  arrow.size = 0.3,
  labels.max.overlaps = Inf,
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)

compute_envfit_vectors(ord, matrix, p_thresh = 0.05, show.significant = FALSE)

stat_barrel_annotate(
  mapping = NULL,
  data = NULL,
  ord,
  position = "identity",
  show.legend = FALSE,
  inherit.aes = TRUE,
  xpad = 0.05,
  ypad = 0.05,
  hjust = 0,
  vjust = 1,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{aes()}.}

\item{data}{Data frame used for plotting.}

\item{geom}{Character; geometric object to use for ellipses, either \code{"path"} or \code{"polygon"}.}

\item{position}{Position adjustment for ggplot2 layers (default \code{"identity"}).}

\item{kind}{Character; type of ellipse: \code{"se"} (standard error), \code{"sd"} (dispersion), or \code{"ci"} (confidence interval).}

\item{conf}{Numeric; confidence level for ellipses (default 0.95).}

\item{method}{Character; covariance estimation method: \code{"classic"} or \code{"robust"}.}

\item{show.legend}{Logical; whether to show legends (default \code{NA}).}

\item{inherit.aes}{Logical; whether to inherit aesthetics (default \code{TRUE}).}

\item{geom_type}{Character; geometric object to use for ellipses, either \code{"path"} or \code{"polygon"}.}

\item{...}{Additional parameters passed to underlying geoms or stats.}

\item{shape}{Integer; shape code for centroid points (default 3).}

\item{ord}{Ordination object from vegan, e.g. \code{rda}, \code{cca}, \code{dbrda}, or \code{metaMDS}.}

\item{matrix}{Optional data frame of environmental variables for arrows.}

\item{labels}{Logical; whether to show labels on environmental arrows (default \code{TRUE}).}

\item{labels.color}{Color of arrow labels (default \code{"black"}).}

\item{labels.size}{Numeric size of arrow labels (default 3).}

\item{labels.fontface}{Font face of arrow labels (default \code{"plain"}).}

\item{show.significant}{Logical; whether to show only significant arrows (default \code{FALSE}).}

\item{p_thresh}{Numeric; p-value threshold for significance filtering (default 0.05).}

\item{arrow}{A grid arrow object controlling arrow appearance (default created by \code{grid::arrow()}).}

\item{arrow.color}{Color of arrows (default \code{"grey10"}).}

\item{arrow.linetype}{Line type of arrows (default \code{"solid"}).}

\item{arrow.size}{Numeric line width of arrows (default 0.3).}

\item{labels.max.overlaps}{Maximum number  of labels in the same space (default \code{"Inf"}).}

\item{xpad}{Numeric; horizontal padding for annotation text relative to x-axis range (default 0.05).}

\item{ypad}{Numeric; vertical padding for annotation text relative to y-axis range (default 0.05).}

\item{hjust}{Numeric; horizontal justification of annotation text (default 0).}

\item{vjust}{Numeric; vertical justification of annotation text (default 1).}
}
\value{
A ggplot2 layer combining ellipses, centroids, arrows, and annotations.
}
\description{
Combines ordination ellipses, centroids, environmental arrows, and annotations into a ggplot2 layer.
}
\details{
Comprehensive Ordination Visualization Layer

This set of ggplot2 stats draws ellipses around groups, centroids, environmental arrows,
and adds adjusted R^2 or stress annotation for ordination objects from vegan.
}
\examples{
library(ggplot2)
library(vegan)
library(robustbase)
data(dune)
data(dune.env)

pca <- vegan::rda(dune, scale = TRUE)
scores <- as.data.frame(vegan::scores(pca, display = "sites"))
scores$Management <- dune.env$Management

ggplot(scores, aes(PC1, PC2, group = Management, fill = Management)) +
  stat_barrel(
    method = "classic", kind = "se", conf = 0.95, geom_type = "polygon",
    alpha = 0.4, color = "black"
  ) +
  stat_barrel_centroid(method = "classic", shape = 3) +
  stat_barrel_arrows(
    ord = pca, matrix = dune,
    labels = TRUE, labels.color = "blue",
    arrow.color = "darkred", arrow.linetype = "solid",
    labels.fontface = "bold", show.significant = TRUE,
    labels.max.overlaps = Inf,
  ) +
  stat_barrel_annotate(ord = pca, xpad = 0.05, ypad = 0.05) +
  geom_point(aes(color = Management)) +
  theme_minimal()

}
\keyword{datasets}
