% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/azure-storage-client.R
\name{api_storage_client}
\alias{api_storage_client}
\title{Azure Storage API Class}
\description{
An R6 class that extends \link{api_client} to provide specialized methods
for Azure Data Lake Storage Gen2 (ADLS Gen2) REST API operations.
}
\details{
The base URL is constructed as:
\verb{https://\{storageaccount\}.dfs.core.windows.net}
}
\examples{
\dontrun{
# Create a storage client
storage <- api_storage_client$new(
  storageaccount = "mystorageaccount",
  filesystem = "mycontainer"
)

# List files in the root directory
files <- storage$list_files()

# List files in a specific path
files <- storage$list_files(path = "data/folder1")

# List files recursively
files <- storage$list_files(path = "data", recursive = TRUE)
}
}
\section{Super class}{
\code{\link[azr:api_client]{azr::api_client}} -> \code{api_storage_client}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{.filesystem}}{The filesystem (container) name}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-api_storage_client-new}{\code{api_storage_client$new()}}
\item \href{#method-api_storage_client-download_file}{\code{api_storage_client$download_file()}}
\item \href{#method-api_storage_client-get_access_control}{\code{api_storage_client$get_access_control()}}
\item \href{#method-api_storage_client-list_files}{\code{api_storage_client$list_files()}}
\item \href{#method-api_storage_client-clone}{\code{api_storage_client$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="azr" data-topic="api_client" data-id=".build_request"><a href='../../azr/html/api_client.html#method-api_client-.build_request'><code>azr::api_client$.build_request()</code></a></span></li>
<li><span class="pkg-link" data-pkg="azr" data-topic="api_client" data-id=".fetch"><a href='../../azr/html/api_client.html#method-api_client-.fetch'><code>azr::api_client$.fetch()</code></a></span></li>
<li><span class="pkg-link" data-pkg="azr" data-topic="api_client" data-id=".get_token"><a href='../../azr/html/api_client.html#method-api_client-.get_token'><code>azr::api_client$.get_token()</code></a></span></li>
<li><span class="pkg-link" data-pkg="azr" data-topic="api_client" data-id=".resp_body_content"><a href='../../azr/html/api_client.html#method-api_client-.resp_body_content'><code>azr::api_client$.resp_body_content()</code></a></span></li>
<li><span class="pkg-link" data-pkg="azr" data-topic="api_client" data-id=".resp_content"><a href='../../azr/html/api_client.html#method-api_client-.resp_content'><code>azr::api_client$.resp_content()</code></a></span></li>
<li><span class="pkg-link" data-pkg="azr" data-topic="api_client" data-id=".send_request"><a href='../../azr/html/api_client.html#method-api_client-.send_request'><code>azr::api_client$.send_request()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-api_storage_client-new"></a>}}
\if{latex}{\out{\hypertarget{method-api_storage_client-new}{}}}
\subsection{Method \code{new()}}{
Create a new Azure Storage API client instance
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{api_storage_client$new(
  storageaccount,
  filesystem,
  scopes = ".default",
  chain = NULL,
  tenant_id = NULL,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{storageaccount}}{A character string specifying the Azure Storage account name.}

\item{\code{filesystem}}{A character string specifying the filesystem (container) name.}

\item{\code{scopes}}{A character string specifying the OAuth2 scope suffix. Defaults to
\code{".default"}, which requests all permissions the app has been granted.}

\item{\code{chain}}{A \link{credential_chain} instance for authentication. If NULL,
a default credential chain will be created using \link{DefaultCredential}.}

\item{\code{tenant_id}}{A character string specifying the Azure tenant ID. Passed to
\link{DefaultCredential} when \code{chain} is \code{NULL}.}

\item{\code{...}}{Additional arguments passed to the parent \link{api_client} constructor.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{api_storage_client} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-api_storage_client-download_file"></a>}}
\if{latex}{\out{\hypertarget{method-api_storage_client-download_file}{}}}
\subsection{Method \code{download_file()}}{
Download a file from the filesystem
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{api_storage_client$download_file(path, dest = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{A character string specifying the file path within the filesystem.}

\item{\code{dest}}{A character string specifying the local destination path.
Defaults to a temporary file via \code{\link[=tempfile]{tempfile()}}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The local path the file was written to (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-api_storage_client-get_access_control"></a>}}
\if{latex}{\out{\hypertarget{method-api_storage_client-get_access_control}{}}}
\subsection{Method \code{get_access_control()}}{
Get the access control list (ACL) for a file or directory
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{api_storage_client$get_access_control(dataset, upn = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dataset}}{A character string specifying the file or directory path within
the filesystem.}

\item{\code{upn}}{A logical value. If \code{TRUE}, user principal names (UPN) are
returned in the \code{x-ms-owner}, \code{x-ms-group}, and \code{x-ms-acl} response
headers instead of object IDs. Defaults to \code{FALSE}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A data.frame with columns \code{group_id} and \code{permission}, one row per
named group entry in the \code{x-ms-acl} response header.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-api_storage_client-list_files"></a>}}
\if{latex}{\out{\hypertarget{method-api_storage_client-list_files}{}}}
\subsection{Method \code{list_files()}}{
List files and directories in a path
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{api_storage_client$list_files(path = "", recursive = FALSE, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{A character string specifying the directory path to list.
Use empty string or NULL for the root directory. Defaults to \code{""}.}

\item{\code{recursive}}{A logical value indicating whether to list files recursively.
Defaults to \code{FALSE}.}

\item{\code{...}}{Additional query parameters to pass to the API.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A data.frame (or data.table if available) containing file and directory
information with columns such as name, contentLength, lastModified, etc.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-api_storage_client-clone"></a>}}
\if{latex}{\out{\hypertarget{method-api_storage_client-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{api_storage_client$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
