% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/credential-refresh-token.R
\name{RefreshTokenCredential}
\alias{RefreshTokenCredential}
\title{Refresh token credential authentication}
\description{
Authenticates using an existing refresh token. This credential is useful when
you have obtained a refresh token through another authentication flow and want
to use it to get new access tokens without interactive authentication.
}
\details{
The refresh token credential uses the OAuth 2.0 refresh token flow to obtain
new access tokens. It requires a valid refresh token that was previously
obtained through an interactive flow (e.g., authorization code or device code).

This is particularly useful for:
\itemize{
\item Non-interactive sessions where you have a pre-obtained refresh token
\item Long-running applications that need to refresh tokens automatically
\item Scenarios where you want to avoid repeated interactive authentication
}
}
\examples{
\dontrun{
# Create credential with a refresh token
cred <- RefreshTokenCredential$new(
  refresh_token = "your-refresh-token",
  scope = "https://management.azure.com/.default",
  tenant_id = "your-tenant-id",
  client_id = "your-client-id"
)

# Get an access token
token <- cred$get_token()

# Use with httr2 request
req <- httr2::request("https://management.azure.com/subscriptions")
resp <- httr2::req_perform(cred$req_auth(req))
}
}
\section{Super class}{
\code{azr::Credential} -> \code{RefreshTokenCredential}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{.refresh_token}}{Character string containing the refresh token.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-RefreshTokenCredential-new}{\code{RefreshTokenCredential$new()}}
\item \href{#method-RefreshTokenCredential-validate}{\code{RefreshTokenCredential$validate()}}
\item \href{#method-RefreshTokenCredential-get_token}{\code{RefreshTokenCredential$get_token()}}
\item \href{#method-RefreshTokenCredential-req_auth}{\code{RefreshTokenCredential$req_auth()}}
\item \href{#method-RefreshTokenCredential-clone}{\code{RefreshTokenCredential$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="azr" data-topic="Credential" data-id="is_interactive"><a href='../../azr/html/Credential.html#method-Credential-is_interactive'><code>azr::Credential$is_interactive()</code></a></span></li>
<li><span class="pkg-link" data-pkg="azr" data-topic="Credential" data-id="print"><a href='../../azr/html/Credential.html#method-Credential-print'><code>azr::Credential$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RefreshTokenCredential-new"></a>}}
\if{latex}{\out{\hypertarget{method-RefreshTokenCredential-new}{}}}
\subsection{Method \code{new()}}{
Create a new refresh token credential
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RefreshTokenCredential$new(
  refresh_token = default_refresh_token(),
  scope = NULL,
  tenant_id = NULL,
  client_id = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{refresh_token}}{A character string containing the refresh token.
Defaults to \code{\link[=default_refresh_token]{default_refresh_token()}} which reads from the
\code{AZURE_REFRESH_TOKEN} environment variable.}

\item{\code{scope}}{A character string specifying the OAuth2 scope. Defaults to \code{NULL}.}

\item{\code{tenant_id}}{A character string specifying the Azure Active Directory
tenant ID. Defaults to \code{NULL}.}

\item{\code{client_id}}{A character string specifying the application (client) ID.
Defaults to \code{NULL}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{RefreshTokenCredential} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RefreshTokenCredential-validate"></a>}}
\if{latex}{\out{\hypertarget{method-RefreshTokenCredential-validate}{}}}
\subsection{Method \code{validate()}}{
Validate the credential configuration
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RefreshTokenCredential$validate()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Checks that the refresh token is provided and not NA or NULL. Calls the
parent class validation method.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RefreshTokenCredential-get_token"></a>}}
\if{latex}{\out{\hypertarget{method-RefreshTokenCredential-get_token}{}}}
\subsection{Method \code{get_token()}}{
Get an access token using the refresh token flow
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RefreshTokenCredential$get_token()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
An \code{\link[httr2:oauth_token]{httr2::oauth_token()}} object containing the access token
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RefreshTokenCredential-req_auth"></a>}}
\if{latex}{\out{\hypertarget{method-RefreshTokenCredential-req_auth}{}}}
\subsection{Method \code{req_auth()}}{
Add OAuth refresh token authentication to an httr2 request
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RefreshTokenCredential$req_auth(req)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{req}}{An \code{\link[httr2:request]{httr2::request()}} object}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The request object with OAuth refresh token authentication configured
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RefreshTokenCredential-clone"></a>}}
\if{latex}{\out{\hypertarget{method-RefreshTokenCredential-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RefreshTokenCredential$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
