% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny-app.R
\name{run_ggstrat_app}
\alias{run_ggstrat_app}
\title{Launch the interactive map with stratigraphy plots}
\usage{
run_ggstrat_app(df, plot_fun = ggstrat_samples)
}
\arguments{
\item{df}{A data frame containing stratigraphic data.}

\item{plot_fun}{A function that generates a stratigraphic plot.
Defaults to \code{\link[=ggstrat_samples]{ggstrat_samples()}}.}
}
\value{
A Shiny app object.
}
\description{
This function launches a Shiny app that displays an interactive map locations
with stratigraphic data. If you click on a station it will generate a stratigraphic
plot with the plotting function of your choice (default is \code{ggstrat_samples()}).
You can also adjust the height of the plot using the slider below the map.
}
\examples{
if (interactive()) {
# Use your default plotting function
run_ggstrat_app(example_data_strat)

# Or swap in a custom plotting function
run_ggstrat_app(example_data_strat, plot_fun = ggstrat_column)
}
}
