% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_data.R
\name{load_geodiva_forms}
\alias{load_geodiva_forms}
\title{Load stratigraphic data from GeoDIVA upload forms}
\usage{
load_geodiva_forms(station_sample_upload, layer_upload, verbose = TRUE)
}
\arguments{
\item{station_sample_upload}{data frame created from uploaded GeoDIVA format
Station/Sample upload sheet, usually uploaded with \code{readxl::read_xlsx()}
linked to filepath.}

\item{layer_upload}{data frame created from uploaded GeoDIVA format
Layers upload sheet, usually uploaded with \code{readxl::read_xlsx()}
linked to filepath.}

\item{verbose}{Logical. If TRUE (default), prints a message listing the
imported stratigraphic sections. Set to FALSE to suppress console output.}
}
\value{
A data frame containing the merged and cleaned stratigraphic
data, ready for further analysis.
}
\description{
\code{load_geodiva_forms()} processes and cleans stratigraphic data from GeoDIVA
upload forms, specifically a form that includes Station and Sample data and
another form that includes the Layer data. It merges these datasets,
resolves any conflicts in key fields, and prepares a consolidated dataset
for further analysis. The function also extracts and, optionally, prints a
list of unique stratigraphic sections.
}
\examples{
# Locate the example Excel files shipped with the package
path_samples <- system.file("extdata", "example_samples_stations_upload_2024.xlsx",
  package = "avstrat"
)
path_layers <- system.file("extdata", "example_layers_upload_2024.xlsx",
  package = "avstrat"
)

# Read them with readxl
library(readxl)
  station_sample_upload <- readxl::read_xlsx(path_samples, sheet = "Data")
  layer_upload <- readxl::read_xlsx(path_layers, sheet = "Data")

  result <- load_geodiva_forms(station_sample_upload, layer_upload)
  head(result)  # result is a data frame
}
