% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sync.R
\name{am_load_changes}
\alias{am_load_changes}
\title{Load a document as individual changes}
\usage{
am_load_changes(data)
}
\arguments{
\item{data}{A raw vector containing a serialized Automerge document
(from \code{\link[=am_save]{am_save()}})}
}
\value{
A list of \code{am_change} objects. Returns an empty list for an
empty document.
}
\description{
Decomposes a serialized document into its individual changes. This is
useful for inspecting the full change history or for selectively applying
changes to another document.
}
\examples{
doc <- am_create()
doc$key <- "value"
am_commit(doc, "Add key")
doc$key2 <- "value2"
am_commit(doc, "Add key2")
bytes <- am_save(doc)

# Load as individual changes
changes <- am_load_changes(bytes)
changes
am_change_message(changes[[1]])  # "Add key"
am_change_message(changes[[2]])  # "Add key2"

# Apply to a new document
doc2 <- am_create()
am_apply_changes(doc2, changes)
doc2$key   # "value"
doc2$key2  # "value2"

am_close(doc)
am_close(doc2)

}
