% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moonphase.R
\name{astro_search_moon_phase}
\alias{astro_search_moon_phase}
\title{Search for a Specific Moon Phase}
\usage{
astro_search_moon_phase(target_lon, start_time, limit_days)
}
\arguments{
\item{target_lon}{A numeric value in the range [0, 360) representing the
target phase angle. Common values: 0 = new moon, 90 = first quarter,
180 = full moon, 270 = third quarter.}

\item{start_time}{A POSIXct datetime to begin the search.}

\item{limit_days}{A numeric value specifying the search window in days.
Positive values search forward, negative values search backward.}
}
\value{
A POSIXct datetime when the Moon reaches the target phase.
}
\description{
Searches for the time when the Moon reaches a specified phase angle.
}
\examples{
start <- as.POSIXct("2025-02-19", tz = "UTC")
astro_search_moon_phase(0, start, 30)  # Find next new moon
}
