% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rotation.R
\name{astro_rotation_EQJ_HOR}
\alias{astro_rotation_EQJ_HOR}
\title{Rotation Matrix from J2000 Equatorial to Horizontal}
\usage{
astro_rotation_EQJ_HOR(time, latitude, longitude, height)
}
\arguments{
\item{time}{A POSIXct object representing the date and time of observation.}

\item{latitude}{The observer's geographic latitude in degrees.}

\item{longitude}{The observer's geographic longitude in degrees.}

\item{height}{The observer's elevation above sea level in meters.}
}
\value{
A rotation matrix that converts EQJ to HOR. The components represent:
x = north, y = west, z = zenith (straight up from observer).
}
\description{
Calculates a rotation matrix from J2000 mean equator (EQJ) to horizontal (HOR).
}
\details{
This is one of the family of functions that returns a rotation matrix
for converting from one orientation to another.

\strong{Source}: EQJ = equatorial system, using the equator at J2000 epoch.

\strong{Target}: HOR = horizontal system (x=North, y=West, z=Zenith).
}
\examples{
astro_rotation_EQJ_HOR(Sys.time(), latitude = -35.28, longitude = 149.12, height = 0)

}
