% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coordinates.R, R/rotation.R
\name{astro_equator_from_vector}
\alias{astro_equator_from_vector}
\title{Convert Cartesian Vector to Equatorial Coordinates}
\usage{
astro_equator_from_vector(vector)

astro_equator_from_vector(vector)
}
\arguments{
\item{vector}{A list with components:
\describe{
\item{x}{The Cartesian x-coordinate in AU}
\item{y}{The Cartesian y-coordinate in AU}
\item{z}{The Cartesian z-coordinate in AU}
\item{t}{The date and time (POSIXct) at which this vector is valid}
}}
}
\value{
A list representing equatorial coordinates with elements:
\itemize{
\item \code{ra}: Right ascension in sidereal hours (0-24)
\item \code{dec}: Declination in degrees (-90 to +90)
\item \code{dist}: Distance in AU
\item \code{vec}: The original vector
\item \code{status}: Status code (0 = success)
}

A list with components:
\describe{
\item{ra}{Right ascension in sidereal hours}
\item{dec}{Declination in degrees}
\item{dist}{Distance to the celestial body in AU}
\item{vec}{Equatorial coordinates in Cartesian vector form}
\item{status}{Status code (0 = success)}
}
}
\description{
Given an equatorial vector, calculates equatorial angular coordinates
(right ascension and declination).

Given an equatorial vector, calculates equatorial angular coordinates
(right ascension and declination).
}
\examples{
vec <- list(x = 1, y = 0.5, z = 0.25, t = as.POSIXct("2024-01-01", tz = "UTC"))
equ <- astro_equator_from_vector(vec)

# Convert vector to equatorial coordinates
vec <- list(x = 1, y = 0, z = 0, t = as.POSIXct("2024-01-01", tz = "UTC"))
equ <- astro_equator_from_vector(vec)
}
