% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert_type.R
\name{assert_string}
\alias{assert_string}
\title{Assert input is a character string}
\usage{
assert_string(x, msg = NULL, call = rlang::caller_env(), arg_name = NULL)
}
\arguments{
\item{x}{An object}

\item{msg}{A character string containing the error message to display if x is not a string}

\item{call}{Only relevant when pooling assertions into multi-assertion helper functions. See \link[cli]{cli_abort} for details.}

\item{arg_name}{Advanced use only. Name of the argument passed (default: NULL, will automatically extract arg_name).}
}
\value{
invisible(TRUE) if x is a string, otherwise aborts with the error message specified by msg
}
\description{
Assert input is a character string
}
\examples{
try({
assert_string("a") # Passes
assert_string(c("a", "b", "c")) # Throws default error
assert_string(1:3) # Throws default error
assert_string(c("a", 1, "b"), "Custom error message") # Throws custom error
})


}
\concept{assert_type}
