% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmml.R
\name{pmml}
\alias{pmml}
\alias{write.PMML}
\alias{read.PMML}
\title{Read and Write PMML}
\usage{
write.PMML(x, file)

read.PMML(file)
}
\arguments{
\item{x}{a \link{rules} or \link{itemsets} object.}

\item{file}{name of the PMML file (for \code{read.PMML()} also a XML root node can be
supplied).}
}
\description{
This function reads and writes PMML representations (version 4.1) of
\link{associations} (\link{itemsets} and \link{rules}). Write delegates to package \pkg{pmml}.
}
\examples{
\dontshow{if (requireNamespace("pmml", quietly = TRUE)) withAutoprint(\{ # examplesIf}
data("Groceries")

rules <- apriori(Groceries, parameter = list(support = 0.001))
rules <- head(rules, by = "lift")
rules

### save rules as PMML
write.PMML(rules, file = "rules.xml")

### read rules back
rules2 <- read.PMML("rules.xml")
rules2

### compare rules
inspect(rules[1])
inspect(rules2[1])

### clean up
unlink("rules.xml")
\dontshow{\}) # examplesIf}
}
\references{
PMML 4.4 - Association Rules.
\url{https://dmg.org/pmml/v4-4/AssociationRules.html}
}
\seealso{
\code{\link[pmml:pmml]{pmml::pmml()}}.

Other import/export: 
\code{\link{DATAFRAME}()},
\code{\link{LIST}()},
\code{\link{read}},
\code{\link{write}()}
}
\author{
Michael Hahsler
}
\concept{import/export}
\keyword{interface}
