% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistical_functions.R
\name{sem_analysis}
\alias{sem_analysis}
\title{Structural Equation Modeling for Field Experiments}
\usage{
sem_analysis(data, model, plot = TRUE, verbose = TRUE)
}
\arguments{
\item{data}{Data frame with variables}

\item{model}{Model specification in lavaan syntax}

\item{plot}{Logical, whether to generate path diagram}

\item{verbose}{Logical. If TRUE (default), prints formatted output to console.}
}
\value{
SEM results including fit indices and parameter estimates
}
\description{
Performs SEM analysis for agricultural field experiments. Allows testing
of hypothesized causal relationships among variables.
}
\examples{
\donttest{
if (requireNamespace("lavaan", quietly = TRUE)) {
  set.seed(42)
  n <- 100
  nitrogen <- rnorm(n, 60, 10)
  phosphorus <- rnorm(n, 30, 5)
  yield <- 0.5 * nitrogen + 0.3 * phosphorus + rnorm(n, 0, 5)
  df <- data.frame(yield = yield, nitrogen = nitrogen, phosphorus = phosphorus)
  model <- 'yield ~ nitrogen + phosphorus'
  result <- sem_analysis(df, model, plot = FALSE)
}
}

}
\author{
Lalit Kumar Rolaniya, ICAR-IIPR, Bikaner
}
