% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orsf_control.R
\name{orsf_control_cph}
\alias{orsf_control_cph}
\title{Cox regression ORSF control}
\usage{
orsf_control_cph(method = "efron", eps = 1e-09, iter_max = 20, ...)
}
\arguments{
\item{method}{(\emph{character}) a character string specifying the method
for tie handling. If there are no ties, all the methods are
equivalent. Valid options are 'breslow' and 'efron'. The Efron
approximation is the default because it is more accurate when dealing
with tied event times and has similar computational efficiency compared
to the Breslow method.}

\item{eps}{(\emph{double}) When using Newton Raphson scoring to identify
linear combinations of inputs, iteration continues in the algorithm
until the relative change in  the log partial likelihood is less than
\code{eps}, or the absolute change is less than \code{sqrt(eps)}. Must be positive.
A default value of 1e-09 is used for consistency with
\link[survival:coxph.control]{survival::coxph.control}.}

\item{iter_max}{(\emph{integer}) iteration continues until convergence
(see \code{eps} above) or the number of attempted iterations is equal to
\code{iter_max}.}

\item{...}{Further arguments passed to or from other methods (not currently used).}
}
\value{
an object of class \code{'orsf_control'}, which should be used as
an input for the \code{control} argument of \link{orsf}.
}
\description{
Use the coefficients from a proportional hazards model
to create linear combinations of predictor variables
while fitting an \link{orsf} model.
}
\details{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}

code from the  \href{https://github.com/therneau/survival/blob/master/src/coxfit6.c}{survival package}
was modified to make this routine.

For more details on the Cox proportional hazards model, see
\link[survival:coxph]{coxph} and/or Therneau and Grambsch (2000).
}
\references{
Therneau T.M., Grambsch P.M. (2000) The Cox Model. In: Modeling Survival
Data: Extending the Cox Model. Statistics for Biology and Health.
Springer, New York, NY. DOI: 10.1007/978-1-4757-3294-8_3
}
\seealso{
linear combination control functions
\code{\link{orsf_control}()},
\code{\link{orsf_control_custom}()},
\code{\link{orsf_control_fast}()},
\code{\link{orsf_control_net}()}
}
\concept{orsf_control}
