% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thematic_trimming.R
\name{getThematicTrimming}
\alias{getThematicTrimming}
\title{Get the Thematic trimming of an Antares study}
\usage{
getThematicTrimming(opts = simOptions())
}
\arguments{
\item{opts}{list of simulation parameters returned by the function
\code{\link{setSimulationPath}}}
}
\value{
\code{data.frame} with 2 columns :
\itemize{
\item \code{variables} : names are displayed according to the study version
\item \code{status_selection} : have 2 possible values ("active"; "skip")
}
}
\description{
\ifelse{html}{\figure{badge_api_ok.svg}{options: alt='Antares API OK'}}{Antares API: \strong{OK}}

This function reads the "selection variables" section of the study's
"generaldata.ini" file.

Minimal version required is \code{v8.8}.
}
\examples{
\dontrun{
# Get Thematic trimming of Antares study version >= v8.8
getThematicTrimming()
}
}
