% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_drug_links.R
\name{add_drug_links}
\alias{add_drug_links}
\title{Add known drug association data}
\usage{
add_drug_links(annotaR_object)
}
\arguments{
\item{annotaR_object}{A tibble, typically from \code{annotaR()}, containing a
'gene' column with HGNC symbols.}
}
\value{
A new tibble with the original data joined with drug association
columns (e.g., drug_name, drug_type, mechanism_of_action, phase).
}
\description{
Augments an annotaR object with known drug/compound data from the
OpenTargets platform. This includes the drug name, type, mechanism of
action, and clinical trial phase.
}
\examples{
\donttest{
  annotaR(c("EGFR", "BRAF")) \%>\%
    add_drug_links()
}
}
