% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gamification.R
\name{anki_gamification}
\alias{anki_gamification}
\title{Gamification Stats}
\usage{
anki_gamification(
  path = NULL,
  profile = NULL,
  xp_per_review = 10,
  xp_per_correct = 5,
  xp_per_streak = 25
)
}
\arguments{
\item{path}{Path to collection.anki2 (auto-detected if NULL)}

\item{profile}{Profile name (first profile if NULL)}

\item{xp_per_review}{XP awarded per review (default 10)}

\item{xp_per_correct}{Bonus XP for correct answer (default 5)}

\item{xp_per_streak}{Bonus XP per day of streak (default 25)}
}
\value{
A list with XP, level, achievements, and stats
}
\description{
Calculate XP, level, achievements, and progress toward goals based on
your Anki review history. Makes studying more engaging!
}
\examples{
\dontrun{
stats <- anki_gamification()
stats$level
stats$achievements
}
}
