% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/video_processing.R
\name{extract_frames}
\alias{extract_frames}
\title{Extract frames from video for classification}
\usage{
extract_frames(
  files,
  frames = 5,
  fps = NULL,
  out_file = NULL,
  out_dir = NULL,
  file_col = "filepath",
  parallel = TRUE,
  num_workers = 4
)
}
\arguments{
\item{files}{dataframe of videos}

\item{frames}{number of frames to sample}

\item{fps}{frames per second, otherwise determine mathematically}

\item{out_file}{csv file to which results will be saved}

\item{out_dir}{directory to save frames to if not null}

\item{file_col}{string value indexing which column contains file paths}

\item{parallel}{Toggle for parallel processing, defaults to FALSE}

\item{num_workers}{number of processors to use if parallel, defaults to 4}
}
\value{
dataframe of still frames for each video
}
\description{
Extract frames from video for classification
}
\examples{
\dontrun{
frames <- extract_frames(manifest, out_dir = "C:\\\\Users\\\\usr\\\\Videos\\\\", frames = 5)
}
}
