\name{detect.interaction}
\alias{detect.interaction}

\title{Detect GxE interaction }

\description{
    Run the AMMI Bayesian model for continuous data.
}

\usage{
detect.interaction(model, type="gen", conf=0.95)
}

\arguments{
  \item{model}{An object ammiBayes}
  \item{type}{Defines the genotypes ("gen") or environments ("env") to be detected with interaction. By default is genotype.}
  \item{conf}{Define the probability of the area of confidence. By default is 0.95.}
}



\author{
        Luciano A. Oliveira \cr
        Carlos P. Silva \cr
        Cristian T. E. Mendes \cr
        Alessandra Q. Silva \cr
        Joel J. Nuvunga \cr
        Marcio Balestre \cr
        Larissa C. V. Boas \cr
        Julio S. S. Bueno-Filho \cr
		Fabio M. Correa
}


\examples{

library(ammiBayes)
data(ammiData)

Env  <- factor(ammiData$amb)
Rep <- factor(ammiData$rep)
Gen  <- factor(ammiData$gen)
Y  <- ammiData$prod

model <- ammiBayes(Y=Y, Gen=Gen, Env=Env, Rep=Rep, iter=10, 
									 burn=1, jump=2, chains=2)

# detect.interaction(model)
}
\keyword{package}

