% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_var_analysis_ratio.R
\name{derive_var_analysis_ratio}
\alias{derive_var_analysis_ratio}
\title{Derive Ratio Variable}
\usage{
derive_var_analysis_ratio(dataset, numer_var, denom_var, new_var = NULL)
}
\arguments{
\item{dataset}{Input dataset

The variables specified by the \code{numer_var} and \code{denom_var} arguments are expected to be in the dataset.

\describe{
\item{Default value}{none}
}}

\item{numer_var}{Variable containing numeric values to be used in the numerator of
the ratio calculation.

\describe{
\item{Default value}{none}
}}

\item{denom_var}{Variable containing numeric values to be used in the denominator of
the ratio calculation.

\describe{
\item{Default value}{none}
}}

\item{new_var}{A user-defined variable that will be appended to the dataset.
The default behavior will take the denominator variable and prefix it with \code{R2}
and append to the dataset. Using this argument will override this default behavior.

Default is \code{NULL}.

\describe{
\item{Default value}{\code{NULL}}
}}
}
\value{
The input dataset with a ratio variable appended
}
\description{
Derives a ratio variable for a BDS dataset based on user specified variables.
}
\details{
A user wishing to calculate a Ratio to Baseline, \code{AVAL / BASE} will
have returned a new variable \code{R2BASE} that will be appended to the input dataset.
Ratio to Analysis Range Lower Limit \code{AVAL / ANRLO} will return a new variable
\code{R2ANRLO}, and Ratio to Analysis Range  Upper Limit \code{AVAL / ANRHI} will return
a new variable \code{R2ANRLO}. Please note how the denominator variable has the prefix
\verb{R2----}. A user can override the default returned variables by using the
\code{new_var} argument. Also, values of 0 in the denominator will return \code{NA} in
the derivation.

Note that \code{R2AyHI} and \code{R2AyLO} can also be derived using this function.

Reference CDISC ADaM Implementation Guide
Version 1.1 Section 3.3.4 Analysis Parameter Variables for BDS Datasets
}
\examples{
library(tibble)

data <- tribble(
  ~USUBJID, ~PARAMCD, ~SEQ, ~AVAL, ~BASE, ~ANRLO, ~ANRHI,
  "P01", "ALT", 1, 27, 27, 6, 34,
  "P01", "ALT", 2, 41, 27, 6, 34,
  "P01", "ALT", 3, 17, 27, 6, 34,
  "P02", "ALB", 1, 38, 38, 33, 49,
  "P02", "ALB", 2, 39, 38, 33, 49,
  "P02", "ALB", 3, 37, 38, 33, 49
)

# Returns "R2" prefixed variables
data \%>\%
  derive_var_analysis_ratio(numer_var = AVAL, denom_var = BASE) \%>\%
  derive_var_analysis_ratio(numer_var = AVAL, denom_var = ANRLO) \%>\%
  derive_var_analysis_ratio(numer_var = AVAL, denom_var = ANRHI)

# Returns user-defined variables
data \%>\%
  derive_var_analysis_ratio(numer_var = AVAL, denom_var = BASE, new_var = R01BASE) \%>\%
  derive_var_analysis_ratio(numer_var = AVAL, denom_var = ANRLO, new_var = R01ANRLO) \%>\%
  derive_var_analysis_ratio(numer_var = AVAL, denom_var = ANRHI, new_var = R01ANRHI)
}
\seealso{
BDS-Findings Functions that returns variable appended to dataset:
\code{\link{derive_basetype_records}()},
\code{\link{derive_var_anrind}()},
\code{\link{derive_var_atoxgr}()},
\code{\link{derive_var_atoxgr_dir}()},
\code{\link{derive_var_base}()},
\code{\link{derive_var_chg}()},
\code{\link{derive_var_nfrlt}()},
\code{\link{derive_var_ontrtfl}()},
\code{\link{derive_var_pchg}()},
\code{\link{derive_var_shift}()},
\code{\link{derive_vars_crit_flag}()}
}
\concept{der_bds_findings}
\keyword{der_bds_findings}
