create_test_forecast_validation <- function(){
  set.seed(123)
  daily_data <- simulate_data(days = 30, peaks = c(flua = 60),
                              amplitudes = c(flua = 90),
                              scales = c(flua = -0.01),
                              time_offset = 45)

  disease_type <- "flua"
  daily_flua <- data.frame(date = daily_data[["date"]],
                           confirm = daily_data[[disease_type]])

  # Run generate_validation
  result <- generate_validation(
    data = daily_flua,
    start_date = "2024-01-10",
    n_days = 7,
    type = "flu_a",
    validate_window_size = 7,
    window_size = 7,
    smooth_data = TRUE,
    smoothing_cutoff = 10
  )

  return(result)
}
