test_that("stability_index returns 1 for identical predictions", {
  preds <- matrix(rep(1:10, 3), ncol = 3)
  expect_equal(stability_index(preds), 1)
})

test_that("stability_index returns value between 0 and 1", {
  set.seed(123)
  preds <- matrix(rnorm(200), ncol = 4)
  result <- stability_index(preds)
  expect_true(result >= 0 && result <= 1)
})

test_that("higher noise yields lower stability", {
  set.seed(42)
  base <- rnorm(50)
  low_noise <- matrix(rep(base, 3) + rnorm(150, sd = 0.01), ncol = 3)
  high_noise <- matrix(rep(base, 3) + rnorm(150, sd = 1.0), ncol = 3)
  expect_true(stability_index(low_noise) > stability_index(high_noise))
})

test_that("stability_index errors on non-matrix input", {
  expect_error(stability_index(c(1, 2, 3)), "must be a matrix")
})

test_that("stability_index errors on single column", {
  expect_error(
    stability_index(matrix(1:10, ncol = 1)),
    "At least two columns"
  )
})

test_that("stability_index errors on NA values", {
  preds <- matrix(c(1, 2, NA, 4, 5, 6), ncol = 2)
  expect_error(stability_index(preds), "must not contain NA")
})

test_that("stability_index errors on non-numeric input", {
  preds <- matrix(c("a", "b", "c", "d"), ncol = 2)
  expect_error(stability_index(preds), "must contain numeric values")
})
