% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_robustness.R
\name{plot_robustness}
\alias{plot_robustness}
\title{Plot Robustness Decay Curve}
\usage{
plot_robustness(
  predict_fn,
  X,
  levels = seq(0, 0.3, by = 0.05),
  n_rep = 5L,
  ...
)
}
\arguments{
\item{predict_fn}{A function that accepts a numeric matrix and returns
a numeric vector of predictions.}

\item{X}{A numeric matrix or data.frame of input features.}

\item{levels}{A numeric vector of noise levels to evaluate.
Default is \code{seq(0, 0.3, by = 0.05)}.}

\item{n_rep}{Number of repetitions for each noise level. Default is \code{5L}.}

\item{...}{Additional arguments passed to \code{\link[graphics]{plot}}.}
}
\value{
A data.frame with columns \code{noise_level} and \code{robustness_score}.
}
\description{
Visualizes how model performance (robustness) decreases as the level
of input noise increases. This "decay curve" is a powerful tool for
understanding the sensitivity threshold of a machine learning model.
}
\examples{
# Simple model
pred_fn <- function(X) X \%*\% c(1, -1)
X <- matrix(rnorm(200), ncol = 2)

# Plot decay
plot_robustness(pred_fn, X, main = "Model Robustness Decay")

}
