% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{PreviousResult}
\alias{PreviousResult}
\alias{add_prev_result}
\alias{get_prev_result}
\title{Find Previous Test Result for Subject}
\usage{
add_prev_result(
  object,
  subject = "subject",
  timepoint = "timepoint",
  result = "result",
  prev_result = "prev_result"
)

get_prev_result(
  object,
  subject = "subject",
  timepoint = "timepoint",
  result = "result"
)
}
\arguments{
\item{object}{a \code{\link{data.frame}} (or object coercible by \code{\link{as.data.frame}()} to
a data frame) containing the data to be analysed.}

\item{subject}{\code{\link{character}}, name of the column (of type \code{\link{integer}} or
\code{\link{factor}}) identifying individual study subjects; default \code{"subject"}.}

\item{timepoint}{\code{character}, name of the column recording time points (as \code{\link{Dates}})
of testing of subjects; default \code{"timepoint"}.}

\item{result}{\code{character}, name of the column (of type \code{\link[base:factor]{ordered factor}},
or binary, see \emph{Details}) recording test results; default \code{"result"}.}

\item{prev_result}{\code{character}, name to be used for a new column to record previous result;
default \code{"prev_result"}.}
}
\value{
\item{\code{add_prev_result()}}{A \code{\link{data.frame}} based on \code{object}, with an added
   column named as specified by argument \code{prev_result} and of type
   \code{\link[base:factor]{ordered factor}} or \code{\link{integer}} depending on whether the
   results are semi-quantitiative or binary.}

\item{\code{get_prev_result()}}{An \code{\link[base:factor]{ordered factor}} of length
   \code{\link{nrow}(object)}, containing the values of the previous test results ordered in the
   exact sequence of the \code{subject} and \code{timepoint} in \code{object}.}
}
\description{
\code{get_prev_result()} identifies the previous test result for individual subjects and timepoints
in a longitudinal study.

\code{add_prev_result()} interpolates these previous test results into a data frame for further analysis.
}
\details{
See \code{\link{Transitions}} \emph{details}.
}
\examples{

\dontshow{
Blackmore <- transform(Blackmore, timepoint = as.Date("2000-01-01") + round(age * 365.25),
    result = cut(exercise, breaks = seq(0, 30, 2), labels = paste0("<=", seq(0, 30, 2)[-1]),
        include.lowest = TRUE, ordered_result = TRUE))
}

 ## Continuing example from `add_transitions()`
  # subject, timepoint and result arguments all defaults and required types
Blackmore |> str()

  # Previous test results as ordered factor
get_prev_result(Blackmore)

  # Previous test result as column of data frame
(Blackmore <- add_prev_result(Blackmore)) |> head(32)

rm(Blackmore)

}
\seealso{
\code{\link{data.frame}}, \code{\link{Dates}}, \code{\link[base:factor]{ordered factor}}.

Other transitions: 
\code{\link{PreviousDate}},
\code{\link{Transitions}},
\code{\link{uniques}()}
}
\concept{transitions}
