% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{PreviousDate}
\alias{PreviousDate}
\alias{add_prev_date}
\alias{get_prev_date}
\title{Find Previous Test Date for Subject}
\usage{
add_prev_date(
  object,
  subject = "subject",
  timepoint = "timepoint",
  result = "result",
  prev_date = "prev_date"
)

get_prev_date(
  object,
  subject = "subject",
  timepoint = "timepoint",
  result = "result"
)
}
\arguments{
\item{object}{a \code{\link{data.frame}} (or object coercible by \code{\link{as.data.frame}()} to
a data frame) containing the data to be analysed.}

\item{subject}{\code{\link{character}}, name of the column (of type \code{\link{integer}} or
\code{\link{factor}}) identifying individual study subjects; default \code{"subject"}.}

\item{timepoint}{\code{character}, name of the column recording time points (as \code{\link{Dates}})
of testing of subjects; default \code{"timepoint"}.}

\item{result}{\code{character}, name of the column (of type \code{\link[base:factor]{ordered factor}},
or binary, see \emph{Details}) recording test results; default \code{"result"}.}

\item{prev_date}{\code{character}, name to be used for a new column to record previous test dates;
default \code{"prev_date"}.}
}
\value{
\item{\code{add_prev_date()}}{A \code{\link{data.frame}} based on \code{object}, with an added
   column named as specified by argument \code{prev_date} of class \code{\link{Date}} containing
   the values of the previous test dates.}

\item{\code{get_prev_date()}}{A \code{vector} of class \code{\link{Date}}, length
   \code{\link{nrow}(object)}, containing the values of the previous test dates ordered in the exact
   sequence of the \code{subject} and \code{timepoint} in \code{object}.}
}
\description{
\code{get_prev_date()} identifies the previous test date for individual subjects and timepoints
in a longitudinal study.

\code{add_prev_date()} interpolates these previous test dates into a data frame for further analysis.
}
\details{
See \code{\link{Transitions}} \emph{details}.
}
\examples{

\dontshow{
Blackmore <- transform(Blackmore, timepoint = as.Date("2000-01-01") + round(age * 365.25),
    result = cut(exercise, breaks = seq(0, 30, 2), labels = paste0("<=", seq(0, 30, 2)[-1]),
        include.lowest = TRUE, ordered_result = TRUE))
}

 ## Continuing example from `add_transitions()`
  # subject, timepoint and result arguments all defaults and required types
Blackmore |> str()

  # Integer vector of the previous test dates
get_prev_date(Blackmore)

  # Add column of  previous test dates to data frame
add_prev_date(Blackmore) |> head(32)

rm(Blackmore)

}
\seealso{
\code{\link{data.frame}}, \code{\link{Dates}}, \code{\link[base:factor]{ordered factor}}.

Other transitions: 
\code{\link{PreviousResult}},
\code{\link{Transitions}},
\code{\link{uniques}()}
}
\concept{transitions}
