% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umx_make}
\alias{umx_make}
\title{"make" the umx package using devtools: release to CRAN etc.}
\usage{
umx_make(
  what = c("load", "quickInst", "install", "spell", "sitrep", "deps_install",
    "checkCRAN", "testthat", "examples", "win", "rhub", "lastRhub", "release", "git"),
  pkg = "~/bin/umx",
  check = TRUE,
  run = FALSE,
  start = NULL,
  spelling = "en_US",
  which = c("win", "mac", "linux", "solaris"),
  run_dont_test = FALSE,
  spell = TRUE
)
}
\arguments{
\item{what}{whether to "install", "release" to CRAN, "test", test on "win", "spell", open "git" app, or run "examples")).}

\item{pkg}{the local path to your package. Defaults to my path to umx.}

\item{check}{Whether to run check on the package before release (default = TRUE).}

\item{run}{If what is "examples", whether to also run examples marked don't run. (default FALSE).}

\item{start}{If what is "examples", which function to start from (default (NULL) = beginning).}

\item{spelling}{Whether to check spelling before release (default = "en_US": set NULL to not check).}

\item{which}{What rhub platform to use? c("mac", "linux", "win").}

\item{run_dont_test}{When checking.}

\item{spell}{for rhub, check spelling? TRUE}
}
\value{
None
}
\description{
Easily  run devtools "install", "release", "win", "examples" etc.
}
\examples{
\dontrun{
# umx_make()  # Just load new code (don't rebuild help etc)
# umx_make(what = "quickInst") # Quick install
# umx_make(what = "install")   # Full package rebuild and install
# umx_make(what = "spell")     # Spellcheck Rd documents
# umx_make(what = "sitrep")    # Are needed packages up to date?
# umx_make(what = "deps_install") # Update needed packages
# umx_make(what = "examples")  # Run the examples
# umx_make(what = "checkCRAN") # Run R CMD check
# umx_make(what = "rhub")      # Check on rhub
# umx_make(what = "win")       # Check on win-builder
# umx_make(what = "release")   # Release to CRAN
# tmp = umx_make(what = "lastRhub") # View rhub result
}
}
\references{
\itemize{
\item \url{https://devtools.r-lib.org}, \url{https://github.com/tbates/umx}
}
}
\seealso{
Other xmu internal not for end user: 
\code{\link{umxModel}()},
\code{\link{umxRenameMatrix}()},
\code{\link{umx_APA_pval}()},
\code{\link{umx_fun_mean_sd}()},
\code{\link{umx_get_bracket_addresses}()},
\code{\link{umx_standardize}()},
\code{\link{umx_string_to_algebra}()},
\code{\link{xmuHasSquareBrackets}()},
\code{\link{xmuLabel_MATRIX_Model}()},
\code{\link{xmuLabel_Matrix}()},
\code{\link{xmuLabel_RAM_Model}()},
\code{\link{xmuMI}()},
\code{\link{xmuMakeDeviationThresholdsMatrices}()},
\code{\link{xmuMakeOneHeadedPathsFromPathList}()},
\code{\link{xmuMakeTwoHeadedPathsFromPathList}()},
\code{\link{xmuMaxLevels}()},
\code{\link{xmuMinLevels}()},
\code{\link{xmuPropagateLabels}()},
\code{\link{xmuRAM2Ordinal}()},
\code{\link{xmuTwinSuper_Continuous}()},
\code{\link{xmuTwinSuper_NoBinary}()},
\code{\link{xmuTwinUpgradeMeansToCovariateModel}()},
\code{\link{xmu_CI_merge}()},
\code{\link{xmu_CI_stash}()},
\code{\link{xmu_DF_to_mxData_TypeCov}()},
\code{\link{xmu_PadAndPruneForDefVars}()},
\code{\link{xmu_bracket_address2rclabel}()},
\code{\link{xmu_cell_is_on}()},
\code{\link{xmu_check_levels_identical}()},
\code{\link{xmu_check_needs_means}()},
\code{\link{xmu_check_variance}()},
\code{\link{xmu_clean_label}()},
\code{\link{xmu_data_missing}()},
\code{\link{xmu_data_swap_a_block}()},
\code{\link{xmu_describe_data_WLS}()},
\code{\link{xmu_dot_make_paths}()},
\code{\link{xmu_dot_make_residuals}()},
\code{\link{xmu_dot_maker}()},
\code{\link{xmu_dot_move_ranks}()},
\code{\link{xmu_dot_rank_str}()},
\code{\link{xmu_extract_column}()},
\code{\link{xmu_get_CI}()},
\code{\link{xmu_lavaan_process_group}()},
\code{\link{xmu_make_TwinSuperModel}()},
\code{\link{xmu_make_bin_cont_pair_data}()},
\code{\link{xmu_make_mxData}()},
\code{\link{xmu_match.arg}()},
\code{\link{xmu_name_from_lavaan_str}()},
\code{\link{xmu_path2twin}()},
\code{\link{xmu_path_regex}()},
\code{\link{xmu_print_algebras}()},
\code{\link{xmu_rclabel_2_bracket_address}()},
\code{\link{xmu_relevel_factors}()},
\code{\link{xmu_safe_run_summary}()},
\code{\link{xmu_set_sep_from_suffix}()},
\code{\link{xmu_show_fit_or_comparison}()},
\code{\link{xmu_simplex_corner}()},
\code{\link{xmu_standardize_ACE}()},
\code{\link{xmu_standardize_ACEcov}()},
\code{\link{xmu_standardize_ACEv}()},
\code{\link{xmu_standardize_CP}()},
\code{\link{xmu_standardize_IP}()},
\code{\link{xmu_standardize_RAM}()},
\code{\link{xmu_standardize_SexLim}()},
\code{\link{xmu_standardize_Simplex}()},
\code{\link{xmu_start_value_list}()},
\code{\link{xmu_starts}()},
\code{\link{xmu_summary_RAM_group_parameters}()},
\code{\link{xmu_twin_add_WeightMatrices}()},
\code{\link{xmu_twin_check}()},
\code{\link{xmu_twin_get_var_names}()},
\code{\link{xmu_twin_make_def_means_mats_and_alg}()},
\code{\link{xmu_twin_upgrade_selDvs2SelVars}()},
\code{\link{xmu_update_covar}()}
}
\concept{xmu internal not for end user}
