% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/learner_mars.R
\name{learner_mars}
\alias{learner_mars}
\title{Construct a learner}
\usage{
learner_mars(
  formula,
  info = "earth::earth",
  degree = 1,
  nprune = NULL,
  glm = NULL,
  learner.args = NULL,
  ...
)
}
\arguments{
\item{formula}{(formula) Formula specifying response and design matrix.}

\item{info}{(character) Optional information to describe the instantiated
\link{learner} object.}

\item{degree}{
     Maximum degree of interaction (Friedman's \eqn{mi}).
     Default is \code{1}, meaning build an additive model (i.e., no interaction terms).
}

\item{nprune}{
     Maximum number of terms (including intercept) in the pruned model.
     Default is NULL, meaning all terms created by the forward pass
     (but typically not all terms will remain after pruning).
     Use this to enforce an upper bound on the model size (that is less than \code{nk}),
     or to reduce exhaustive search time with \code{pmethod="exhaustive"}.
\cr\cr
     \bold{The following arguments are for cross validation.}
}

\item{glm}{
     NULL (default) or a list of arguments to pass on to \code{\link{glm}}.
     See the documentation of \code{\link{glm}} for a description of these arguments
     See \dQuote{\emph{Generalized linear models}} in the vignette.
     Example:\cr
     \code{earth(survived~., data=etitanic, degree=2, glm=list(family=binomial))}
\cr\cr
     \bold{The following arguments are for the forward pass.}
}

\item{learner.args}{(list) Additional arguments to
\link[=learner]{learner$new()}.}

\item{...}{Additional arguments to \link[earth:earth]{earth::earth}.}
}
\value{
\link{learner} object.
}
\description{
Constructs a \link{learner} class object for fitting multivariate
adaptive regression splines with \link[earth:earth]{earth::earth}.
}
\examples{
# poisson regression
n <- 5e2
x <- rnorm(n)
w <- 50 + rexp(n, rate = 1 / 5)
y <- rpois(n, exp(2 + 0.5 * x + log(w)) * rgamma(n, 1 / 2, 1 / 2))
d0 <- data.frame(y, x, w)

lr <- learner_mars(y ~ x + offset(log(w)), degree = 2,
  glm = list(family = poisson())
)
lr$estimate(d0)
lr$predict(data.frame(x = 0, w = c(1, 2)))
}
