% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa.R
\name{random_key}
\alias{random_key}
\title{Generate a random key compatible with encryption and decryption in requests and responses}
\usage{
random_key()
}
\value{
A 32-bit key as a hex-encoded string
}
\description{
The encryption/decryption used in reqres is based on the \href{https://github.com/r-lib/sodium}{sodium}
package and requires a 32-bit encryption key encoded as hexadecimal values.
While you can craft your own, this function will take care of creating a
compliant key using a cryptographically secure pseudorandom number generator
from \code{sodium::helpers()}.
}
\details{
Keep your encryption keys safe! Anyone with the key will be able to eavesdrop
on your communication and tamper with the information stored in encrypted
cookies through man-in-the-middle attacks. The best approach is to use the
keyring package to manage your keys, but as an alternative you can store it
as environment variables.

\strong{NEVER STORE THE KEY IN PLAIN TEXT.}

\strong{NEVER PUT THE KEY SOMEWHERE WHERE IT CAN ACCIDENTALLY BE COMMITTED TO GIT OR
OTHER VERSION CONTROL SOFTWARE}
}
\examples{
\dontshow{if (FALSE) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Store a key with keyring and use it
keyring::key_set_with_value("reqres_key", random_key())

rook <- fiery::fake_request("http://example.com")

Request$new(rook, key = keyring::key_get("reqres_key"))
\dontshow{\}) # examplesIf}
}
