% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/small_helpers.R
\name{inverse}
\alias{inverse}
\title{Get Variable Names which are not Part of the Given Vector}
\usage{
inverse(data_frame, var_names)
}
\arguments{
\item{data_frame}{The data frame from which to take the variable names.}

\item{var_names}{A character vector of variable names.}
}
\value{
Returns the inverse vector of variable names compared to the given vector.
}
\description{
If you have stored variable names inside a character vector, this function gives you
the inverse variable name vector.
}
\examples{
# Example data frame
my_data <- dummy_data(1000)

# Get variable names
var_names <- c("year", "age", "sex")
other_names <- my_data |> inverse(var_names)

# Can also be used to just get all variable names
all_names <- my_data |> inverse(NULL)
all_names <- my_data |> inverse(character(0))


}
