% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_pdiff_two.R
\name{estimate_pdiff_two}
\alias{estimate_pdiff_two}
\title{Estimates for a two-group study with a categorical outcome variable}
\usage{
estimate_pdiff_two(
  data = NULL,
  outcome_variable = NULL,
  grouping_variable = NULL,
  comparison_cases = NULL,
  comparison_n = NULL,
  reference_cases = NULL,
  reference_n = NULL,
  case_label = 1,
  not_case_label = NULL,
  grouping_variable_levels = NULL,
  outcome_variable_name = "My outcome variable",
  grouping_variable_name = "My grouping variable",
  conf_level = 0.95,
  count_NA = FALSE
)
}
\arguments{
\item{data}{For raw data - a data frame or tibble}

\item{outcome_variable}{For raw data - The column name of the outcome
variable which is a factor, or a vector that is a factor}

\item{grouping_variable}{For raw data - The column name of the grouping
variable which is a factor, or a vector that is a factor}

\item{comparison_cases}{For summary data, a numeric integer >= 0}

\item{comparison_n}{For summary data, a numeric integer >= comparison_events}

\item{reference_cases}{For summary data, a numeric integer >= 0}

\item{reference_n}{For summary data, a numeric integer >= reference_events}

\item{case_label}{An optional numeric or character label for the
case level.}

\item{not_case_label}{An optional numeric or character label for the
not case level.}

\item{grouping_variable_levels}{For summary data - An optional vector of
2 group labels}

\item{outcome_variable_name}{Optional friendly name for the outcome variable.
Defaults to 'My outcome variable' or the outcome variable column name if a
data frame is passed.}

\item{grouping_variable_name}{Optional friendly name for the grouping
variable.  Defaults to 'My grouping variable' or the grouping variable
column name if a data.frame is passed.}

\item{conf_level}{The confidence level for the confidence interval.  Given in
decimal form.  Defaults to 0.95.}

\item{count_NA}{Logical to count NAs (TRUE) in total N or not (FALSE)}
}
\value{
Returns object of class esci_estimate
\itemize{
\item \strong{es_proportion_difference}
\itemize{
\item \emph{type} -
\item \emph{outcome_variable_name} -
\item \emph{case_label} -
\item \emph{grouping_variable_name} -
\item \emph{effect} -
\item \emph{effect_size} -
\item \emph{LL} -
\item \emph{UL} -
\item \emph{SE} -
\item \emph{effect_size_adjusted} -
\item \emph{ta_LL} -
\item \emph{ta_UL} -
}
\item \strong{es_odds_ratio}
\itemize{
\item \emph{outcome_variable_name} -
\item \emph{case_label} -
\item \emph{grouping_variable_name} -
\item \emph{effect} -
\item \emph{effect_size} -
\item \emph{SE} -
\item \emph{LL} -
\item \emph{UL} -
\item \emph{ta_LL} -
\item \emph{ta_UL} -
}
\item \strong{overview}
\itemize{
\item \emph{grouping_variable_name} -
\item \emph{grouping_variable_level} -
\item \emph{outcome_variable_name} -
\item \emph{outcome_variable_level} -
\item \emph{cases} -
\item \emph{n} -
\item \emph{P} -
\item \emph{P_LL} -
\item \emph{P_UL} -
\item \emph{P_SE} -
\item \emph{P_adjusted} -
\item \emph{ta_LL} -
\item \emph{ta_UL} -
}
\item \strong{es_phi}
\itemize{
\item \emph{grouping_variable_name} -
\item \emph{outcome_variable_name} -
\item \emph{effect} -
\item \emph{effect_size} -
\item \emph{SE} -
\item \emph{LL} -
\item \emph{UL} -
}
}
}
\description{
Returns object
\code{estimate_pdiff_two} is suitable for a simple two-group design
with a categorical outcome variable.  It provides estimates and CIs for the
difference in proportions between the two groups, the odds ratio, and phi.
You can pass raw data or summary data.
}
\details{
Once you generate an estimate with this function, you can visualize
it with \code{\link[=plot_mdiff]{plot_mdiff()}} and you can test hypotheses with
\code{\link[=test_mdiff]{test_mdiff()}}.

The estimated mean differences are from \code{\link[statpsych:ci.prop2]{statpsych::ci.prop2()}}.

The estimated odds ratio is from \code{\link[statpsych:ci.oddsratio]{statpsych::ci.oddsratio()}}.

The estimated correlation (phi) is from \code{\link[statpsych:ci.phi]{statpsych::ci.phi()}}.
}
\examples{
data("data_campus_involvement")

estimate_from_raw <- esci::estimate_pdiff_two(
  esci::data_campus_involvement,
  CommuterStatus,
  Gender
)

# To visualize the estimate
myplot_from_raw <- esci::plot_pdiff(estimate_from_raw)

# To conduct a hypothesis test
res_htest_from_raw <- esci::test_pdiff(estimate_from_raw)


# From summary_data
estimate_from_summary <- esci::estimate_pdiff_two(
  comparison_cases = 10,
  comparison_n = 20,
  reference_cases = 78,
  reference_n = 252,
  grouping_variable_levels = c("Original", "Replication"),
  conf_level = 0.95
)

# To visualize the estimate
myplot_from_summary <- esci::plot_pdiff(estimate_from_summary)

#' # To conduct a hypothesis test
res_htest_from_summary <- esci::test_pdiff(estimate_from_summary)


}
