% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glmnet_with_cv.R
\name{glmnet_with_cv}
\alias{glmnet_with_cv}
\title{Fit a glmnet Model with Cross-Validation}
\usage{
glmnet_with_cv(
  formula,
  data,
  glmnet_alpha = c(0, 0.25, 0.5, 0.75, 1),
  standardize = TRUE,
  nfolds = 10,
  repeats = 5,
  choose_rule = c("min", "1se"),
  seed = NULL,
  exclude = NULL,
  relaxed = FALSE,
  relax_gamma = NULL,
  ...
)
}
\arguments{
\item{formula}{Model formula.}

\item{data}{Data frame.}

\item{glmnet_alpha}{Numeric vector of alphas, default c(0,0.25,0.5,0.75, 1).}

\item{standardize}{Logical passed to glmnet (default TRUE).}

\item{nfolds}{CV folds (default 10), internally constrained so >= ~3 obs/fold.}

\item{repeats}{Number of independent CV repeats (default 5).}

\item{choose_rule}{"1se" or "min" (default). In simulations "1se" lead to increased RMSE on holdout data when simulating small mixture designs.}

\item{seed}{Optional integer seed for reproducible fold IDs.}

\item{exclude}{Optional vector OR function for glmnet's exclude=.
If a function, cv.glmnet applies it inside each training fold (glmnet >= 4.1-2).}

\item{relaxed}{Logical; if TRUE, call glmnet/cv.glmnet with relax=TRUE (default FALSE).}

\item{relax_gamma}{Optional numeric vector passed as gamma= to glmnet/cv.glmnet
when relaxed=TRUE. If NULL, glmnet uses its internal default gamma path.}

\item{...}{Args forwarded to both cv.glmnet() and glmnet(), e.g.
family, weights, parallel, type.measure, intercept, maxit, lower.limits,
upper.limits, penalty.factor, offset, standardize.response, keep, etc.}
}
\value{
A list with elements:
\itemize{
\item parms Named numeric vector of coefficients (including "(Intercept)").
\item glmnet_alpha Numeric vector of alphas searched.
\item best_alpha Numeric; winning alpha.
\item best_lambda Numeric; winning lambda.
\item y_pred In-sample predictions from the returned coefficients.
\item debias_fit Optional lm(y ~ y_pred) for Gaussian family.
\item y_pred_debiased If debias_fit exists, its fitted values.
\item cv_summary Per-alpha data frames with lambda, mean_cvm, sd_cvm, se_combined, n_repeats, idx_min, idx_1se.
\item formula Original formula.
\item terms Cleaned training terms (environment set to baseenv()).
\item training_X Training design matrix without intercept.
\item actual_y Training response vector.
\item xlevels Factor levels seen during training (for safe predict).
\item contrasts Contrasts used during training (for safe predict).
\item schema list(feature_names, terms_str, xlevels, contrasts, terms_hash) for deterministic predict.
\item note Character vector of notes (e.g., dropped rows, relaxed-coef source).
\item meta List: nfolds, repeats, rule, family, relaxed, relax_cv_fallbacks, cv_object (if keep=TRUE for the final fit).
}
}
\description{
Repeated K-fold CV over a per-alpha lambda path, with a proper
1-SE rule across repeats. Preserves fields expected by predict_cv().
Optionally uses glmnet's built-in relaxed elastic net for both the warm-start
path and each CV fit. When relaxed=TRUE, the final coefficients are taken
from a cv.glmnet() object at the chosen lambda so that the returned model
reflects the relaxed solution (including its gamma).
}
\details{
To avoid duplicate-argument errors, arguments like x, y, alpha, lambda,
foldid, and exclude are passed explicitly and removed from the dots
before calling glmnet::cv.glmnet().
}
\examples{
set.seed(123)
n <- 100; p <- 10
X <- matrix(rnorm(n * p), n, p)
beta <- c(1, -1, rep(0, p - 2))
y <- as.numeric(X \%*\% beta + rnorm(n))
df_ex <- data.frame(y = y, X)
colnames(df_ex) <- c("y", paste0("x", 1:p))

# Default: 1SE rule, repeats=1, non-relaxed
fit_1se <- glmnet_with_cv(y ~ ., df_ex, glmnet_alpha = c(0.5, 1),
                          nfolds = 5, repeats = 1, seed = 42)
str(fit_1se$parms)

# v1-like behavior: choose_rule="min"
fit_min <- glmnet_with_cv(y ~ ., df_ex, glmnet_alpha = 1,
                          nfolds = 5, repeats = 1, choose_rule = "min", seed = 42)

# Relaxed path with gamma search
fit_relax <- glmnet_with_cv(y ~ ., df_ex, glmnet_alpha = 1,
                            nfolds = 5, repeats = 1, relaxed = TRUE, seed = 42)

}
