% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summariseDrugRestart.R
\name{summariseDrugRestart}
\alias{summariseDrugRestart}
\title{Summarise the drug restart for each follow-up period of interest.}
\usage{
summariseDrugRestart(
  cohort,
  cohortId = NULL,
  switchCohortTable,
  switchCohortId = NULL,
  strata = list(),
  followUpDays = Inf,
  censorDate = NULL,
  incident = TRUE,
  restrictToFirstDiscontinuation = TRUE
)
}
\arguments{
\item{cohort}{A cohort_table object.}

\item{cohortId}{A cohort definition id to restrict by. If NULL, all cohorts
will be included.}

\item{switchCohortTable}{A cohort table in the cdm that contains possible
alternative treatments.}

\item{switchCohortId}{The cohort ids to be used from switchCohortTable. If
NULL all cohort definition ids are used.}

\item{strata}{A list of variables to stratify results. These variables
must have been added as additional columns in the cohort table.}

\item{followUpDays}{A vector of number of days to follow up. It can be
multiple values.}

\item{censorDate}{Name of a column that indicates the date to stop the
analysis, if NULL end of individuals observation is used.}

\item{incident}{Whether the switch treatment has to be incident (start after
discontinuation) or not (it can start before the discontinuation and last
till after).}

\item{restrictToFirstDiscontinuation}{Whether to consider only the first
discontinuation episode or all of them.}
}
\value{
A summarised_result object with the percentages of restart, switch
and not exposed per follow-up period given.
}
\description{
Summarise the drug restart for each follow-up period of interest.
}
\examples{
\donttest{
library(DrugUtilisation)

cdm <- mockDrugUtilisation()

conceptlist <- list(acetaminophen = 1125360, metformin = c(1503297, 1503327))
cdm <- generateDrugUtilisationCohortSet(cdm = cdm,
                                        name = "switch_cohort",
                                        conceptSet = conceptlist)

result <- cdm$cohort1 |>
  summariseDrugRestart(switchCohortTable = "switch_cohort")

tableDrugRestart(result)
}
}
